/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds;

import com.sansec.device.bean.DeviceInfo;
import com.sansec.device.bean.GlobalData;
import com.sansec.device.bean.RSArefKeyPair;
import com.sansec.device.bean.RSArefPrivateKey;
import com.sansec.device.bean.RSArefPublicKey;
import com.sansec.device.bean.RetVal;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refKeyPair;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.bean.SwError;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.device.sds.UtilDevcie;
import com.sansec.device.sds.local.Device;
import java.util.logging.Logger;

public class CardDevice
extends UtilDevcie
implements ISDSCrypto {
    private static final boolean racalSupport = true;
    private Device device = new Device();
    protected Logger logger = GlobalData.logger;

    public CardDevice() throws CryptoException {
        try {
            Device.initializeLib();
            int nRetCode = this.device.openDevice();
            if (nRetCode != 0) {
                throw new Exception("\u6253\u5f00\u8bbe\u5907\u9519\u8bef: " + SwError.toErrorInfo(nRetCode));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public byte[] generateRandom(int length) throws CryptoException {
        if (length < 1) {
            throw new CryptoException("\u9700\u8981\u4ea7\u751f\u7684\u968f\u673a\u6570\u592a\u77ed(" + length + ")");
        }
        if (length > 8192) {
            throw new CryptoException("\u9700\u8981\u4ea7\u751f\u7684\u968f\u673a\u6570\u592a\u957f(" + length + ")");
        }
        byte[] retBytes = this.device.generateRandom(length);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u4ea7\u751f\u968f\u673a\u6570\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public DeviceInfo getDeviceInfo() throws CryptoException {
        byte[] retBytes = this.device.getDeviceInfo();
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] data = val.getData();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.decode(data);
        return deviceInfo;
    }

    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        byte[] retBytes = this.device.rsaExportPublicKey(keyIndex, kpType);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5bfc\u51faRSA\u516c\u94a5\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] pubkey = val.getData();
        RSArefPublicKey refPublicKey = new RSArefPublicKey();
        refPublicKey.decode(pubkey);
        return refPublicKey;
    }

    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        if (keysize < 1024 || keysize > 2048 || keysize % 128 != 0) {
            throw new CryptoException("\u975e\u6cd5\u7684RSA\u5bc6\u94a5\u6a21\u957f( " + keysize + " )");
        }
        byte[] retBytes = this.device.rsaGenerateKeyPair(keysize);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u4ea7\u751fRSA\u5bc6\u94a5\u5bf9\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] buf = val.getData();
        RSArefPublicKey refPublicKey = new RSArefPublicKey();
        RSArefPrivateKey refPrivateKey = new RSArefPrivateKey();
        byte[] pubkey = new byte[RSArefPublicKey.sizeof()];
        byte[] prikey = new byte[RSArefPrivateKey.sizeof()];
        System.arraycopy(buf, 0, pubkey, 0, pubkey.length);
        System.arraycopy(buf, pubkey.length, prikey, 0, prikey.length);
        refPublicKey.decode(pubkey);
        refPrivateKey.decode(prikey);
        return new RSArefKeyPair(refPublicKey, refPrivateKey);
    }

    public byte[] rsaPrivateKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7: " + keyIndex);
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.rsaInternalPrivateKeyOperation(keyIndex, kpType, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8RSA\u79c1\u94a5\u8fd0\u7b97\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] rsaPublicKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7: " + keyIndex);
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.rsaInternalPublicKeyOperation(keyIndex, kpType, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8RSA\u516c\u94a5\u94a5\u8fd0\u7b97\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        if (refPublicKey.getBits() >> 3 != input.length) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u957f\u5ea6\u4e0d\u7b49\u4e8e\u516c\u94a5\u6a21\u957f, \u516c\u94a5\u6a21\u957f:\u8fd0\u7b97\u6570\u636e( " + (refPublicKey.getBits() >> 3) + ":" + input.length + " )");
        }
        byte[] retBytes = this.device.rsaExternalPublicKeyOperation(refPublicKey.encode(), input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8RSA\u516c\u94a5\u8fd0\u7b97\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        if (refPrivateKey.getBits() >> 3 != input.length) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u957f\u5ea6\u4e0d\u7b49\u4e8e\u516c\u94a5\u6a21\u957f, \u516c\u94a5\u6a21\u957f:\u8fd0\u7b97\u6570\u636e( " + (refPrivateKey.getBits() >> 3) + ":" + input.length + " )");
        }
        byte[] retBytes = this.device.rsaExternalPrivateKeyOperation(refPrivateKey.encode(), input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8RSA\u79c1\u94a5\u8fd0\u7b97\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public SM2refPublicKey getSM2PublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        byte[] retBytes = this.device.sm2ExportPublicKey(keyIndex, kpType);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5bfc\u51faSM2\u516c\u94a5\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] pubkey = val.getData();
        SM2refPublicKey refPublicKey = new SM2refPublicKey();
        refPublicKey.decode(pubkey);
        return refPublicKey;
    }

    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("\u975e\u6cd5\u7684SM2\u5bc6\u94a5\u6a21\u957f( " + keysize + " )");
        }
        byte[] retBytes = this.device.sm2GenerateKeyPair(keysize);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u4ea7\u751fSM2\u5bc6\u94a5\u5bf9\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] buf = val.getData();
        SM2refPublicKey refPublicKey = new SM2refPublicKey();
        SM2refPrivateKey refPrivateKey = new SM2refPrivateKey();
        byte[] pubkey = new byte[SM2refPublicKey.sizeof()];
        byte[] prikey = new byte[SM2refPrivateKey.sizeof()];
        System.arraycopy(buf, 0, pubkey, 0, pubkey.length);
        System.arraycopy(buf, pubkey.length, prikey, 0, prikey.length);
        refPublicKey.decode(pubkey);
        refPrivateKey.decode(prikey);
        return new SM2refKeyPair(refPublicKey, refPrivateKey);
    }

    public SM2refCipher sm2Encrypt(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.sm2InternalEncrypt(keyIndex, kpType, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8SM2\u52a0\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] cipher = val.getData();
        SM2refCipher refCipher = new SM2refCipher();
        refCipher.decode(cipher);
        return refCipher;
    }

    public byte[] sm2Decrypt(int keyIndex, int kpType, SM2refCipher refCipher) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        if (refCipher == null) {
            throw new CryptoException("\u5bc6\u6587\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.sm2InternalDecrypt(keyIndex, kpType, refCipher.encode());
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8SM2\u89e3\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] plain = val.getData();
        return plain;
    }

    public SM2refCipher sm2Encrypt(SM2refPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u4e3a\u7a7a");
        }
        if (input.length > 136) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u592a\u957f\u4e0d\u652f\u6301( " + input.length + " )");
        }
        byte[] retBytes = this.device.sm2ExternalEncrypt(refPublicKey.encode(), input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8SM2\u52a0\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] cipher = val.getData();
        SM2refCipher refCipher = new SM2refCipher();
        refCipher.decode(cipher);
        return refCipher;
    }

    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, SM2refCipher refCipher) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (refCipher == null) {
            throw new CryptoException("\u5bc6\u6587\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.sm2ExternalDecrypt(refPrivateKey.encode(), refCipher.encode());
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8SM2\u89e3\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] plain = val.getData();
        return plain;
    }

    public SM2refSignature sm2Sign(int keyIndex, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        int kpType = 2;
        byte[] retBytes = this.device.sm2InternalSign(keyIndex, kpType, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8SM2\u7b7e\u540d\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] sigedData = val.getData();
        SM2refSignature refSignature = new SM2refSignature();
        refSignature.decode(sigedData);
        return refSignature;
    }

    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        byte[] retBytes = this.device.sm2ExternalSign(refPrivateKey.encode(), input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8SM2\u7b7e\u540d\u9519\u8bef: " + val.getErrInfo());
        }
        byte[] sigedData = val.getData();
        SM2refSignature refSignature = new SM2refSignature();
        refSignature.decode(sigedData);
        return refSignature;
    }

    public boolean sm2Verify(int keyIndex, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        if (refSig == null) {
            throw new CryptoException("\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        int kpType = 2;
        byte[] retBytes = this.device.sm2InternalVerify(keyIndex, kpType, input, refSig.encode());
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8SM2\u9a8c\u7b7e\u9519\u8bef: " + val.getErrInfo());
        }
        return true;
    }

    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        if (refSig == null) {
            throw new CryptoException("\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.sm2ExternalVerify(refPublicKey.encode(), input, refSig.encode());
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u90e8SM2\u9a8c\u7b7e\u9519\u8bef: " + val.getErrInfo());
        }
        return true;
    }

    public byte[] encrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algId, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.externalEncrypt(key, algId, iv, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u9001\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algId) + " )\u52a0\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] decrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algId, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u5bc6\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.externalDecrypt(key, algId, iv, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5916\u9001\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algId) + " )\u89e3\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] encrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algId, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u5bc6\u94a5\u5e8f\u53f7\u975e\u6cd5( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.internalEncrypt(keyIndex, algId, iv, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8( " + keyIndex + " )\u53f7\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algId) + " )\u52a0\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }

    public byte[] decrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algId, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u5bc6\u94a5\u5e8f\u53f7\u975e\u6cd5( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u5bc6\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        byte[] retBytes = this.device.internalDecrypt(keyIndex, algId, iv, input);
        RetVal val = new RetVal(retBytes);
        if (!val.isCorrect()) {
            throw new CryptoException("\u5185\u90e8( " + keyIndex + " )\u53f7\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algId) + " )\u89e3\u5bc6\u9519\u8bef: " + val.getErrInfo());
        }
        return val.getData();
    }
}

