/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds;

import com.sansec.device.bean.DeviceInfo;
import com.sansec.device.bean.RSArefKeyPair;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refKeyPair;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.device.sds.SymmAlgo;

public class CryptoDevice
implements ISDSCrypto {
    public static final int MAX_LENGTH = 8000;
    private ISDSCrypto crypto = null;

    public CryptoDevice(ISDSCrypto crypto) {
        this.crypto = crypto;
    }

    public byte[] generateRandom(int length) throws CryptoException {
        byte[] output = new byte[length];
        byte[] bufOutput = null;
        int nLeftLen = length;
        while (nLeftLen > 8000) {
            bufOutput = this.crypto.generateRandom(8000);
            System.arraycopy(bufOutput, 0, output, output.length - nLeftLen, 8000);
            nLeftLen -= 8000;
        }
        bufOutput = this.crypto.generateRandom(nLeftLen);
        System.arraycopy(bufOutput, 0, output, output.length - nLeftLen, nLeftLen);
        return output;
    }

    public byte[] encrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo(algId);
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getBlockLen()];
        }
        byte[] output = null;
        if (input.length > 8000) {
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            int nLeftLen = input.length;
            while (nLeftLen > 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                bufOut = this.crypto.encrypt(algId, key, iv, bufIn);
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufOut, 8000 - iv.length, iv, 0, iv.length);
                nLeftLen -= 8000;
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            bufOut = this.crypto.encrypt(algId, key, iv, bufIn);
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufOut, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            output = this.crypto.encrypt(algId, key, iv, input);
        }
        return output;
    }

    public byte[] decrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo(algId);
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getBlockLen()];
        }
        byte[] output = null;
        if (input.length > 8000) {
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            int nLeftLen = input.length;
            while (nLeftLen > 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                bufOut = this.crypto.decrypt(algId, key, iv, bufIn);
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufIn, 8000 - iv.length, iv, 0, iv.length);
                nLeftLen -= 8000;
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            bufOut = this.crypto.decrypt(algId, key, iv, bufIn);
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufIn, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            output = this.crypto.decrypt(algId, key, iv, input);
        }
        return output;
    }

    public byte[] encrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo(algId);
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getBlockLen()];
        }
        byte[] output = null;
        if (input.length > 8000) {
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            int nLeftLen = input.length;
            while (nLeftLen > 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                bufOut = this.crypto.encrypt(algId, keyIndex, iv, bufIn);
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufOut, 8000 - iv.length, iv, 0, iv.length);
                nLeftLen -= 8000;
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            bufOut = this.crypto.encrypt(algId, keyIndex, iv, bufIn);
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufOut, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            output = this.crypto.encrypt(algId, keyIndex, iv, input);
        }
        return output;
    }

    public byte[] decrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo(algId);
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getBlockLen()];
        }
        byte[] output = null;
        if (input.length > 8000) {
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            int nLeftLen = input.length;
            while (nLeftLen > 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                bufOut = this.crypto.decrypt(algId, keyIndex, iv, bufIn);
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufIn, 8000 - iv.length, iv, 0, iv.length);
                nLeftLen -= 8000;
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            bufOut = this.crypto.decrypt(algId, keyIndex, iv, bufIn);
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufIn, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            output = this.crypto.decrypt(algId, keyIndex, iv, input);
        }
        return output;
    }

    public DeviceInfo getDeviceInfo() throws CryptoException {
        try {
            return this.crypto.getDeviceInfo();
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        try {
            return this.crypto.getRSAPublicKey(keyIndex, keyType);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        try {
            return this.crypto.generateRSAKeyPair(keysize);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] rsaPrivateKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        try {
            return this.crypto.rsaPrivateKeyOperation(keyIndex, keyType, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] rsaPublicKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        try {
            return this.crypto.rsaPublicKeyOperation(keyIndex, keyType, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.rsaPublicKeyOperation(refPublicKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.rsaPrivateKeyOperation(refPrivateKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refPublicKey getSM2PublicKey(int keyIndex, int keyType) throws CryptoException {
        try {
            return this.crypto.getSM2PublicKey(keyIndex, keyType);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        try {
            return this.crypto.generateSM2KeyPair(keysize);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refCipher sm2Encrypt(int keyIndex, int keyType, byte[] input) throws CryptoException {
        try {
            return this.crypto.sm2Encrypt(keyIndex, keyType, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] sm2Decrypt(int keyIndex, int keyType, SM2refCipher refCipher) throws CryptoException {
        try {
            return this.crypto.sm2Decrypt(keyIndex, keyType, refCipher);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refCipher sm2Encrypt(SM2refPublicKey refPublicKey, byte[] dataInput) throws CryptoException {
        try {
            return this.crypto.sm2Encrypt(refPublicKey, dataInput);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, SM2refCipher dataInput) throws CryptoException {
        try {
            return this.crypto.sm2Decrypt(refPrivateKey, dataInput);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refSignature sm2Sign(int keyIndex, byte[] input) throws CryptoException {
        try {
            return this.crypto.sm2Sign(keyIndex, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.sm2Sign(refPrivateKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public boolean sm2Verify(int keyIndex, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        try {
            return this.crypto.sm2Verify(keyIndex, dataInput, refSig);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        try {
            return this.crypto.sm2Verify(refPublicKey, dataInput, refSig);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }
}

