/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds;

import com.sansec.device.bean.ByteKeyPair;
import com.sansec.device.bean.DeviceInfo;
import com.sansec.device.bean.ExRSArefPrivateKey;
import com.sansec.device.bean.ExRSArefPublicKey;
import com.sansec.device.bean.RSArefKeyPair;
import com.sansec.device.bean.RSArefPrivateKey;
import com.sansec.device.bean.RSArefPublicKey;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refKeyPair;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.device.sds.UtilDevcie;
import com.sansec.device.sds.cmd.SDSCmd;

public class HSMDevice
extends UtilDevcie
implements ISDSCrypto {
    private static final boolean racalSupport = true;

    public byte[] generateRandom(int length) throws CryptoException {
        if (length < 1) {
            throw new CryptoException("\u9700\u8981\u4ea7\u751f\u7684\u968f\u673a\u6570\u592a\u77ed(" + length + ")");
        }
        if (length > 8192) {
            throw new CryptoException("\u9700\u8981\u4ea7\u751f\u7684\u968f\u673a\u6570\u592a\u957f(" + length + ")");
        }
        try {
            return SDSCmd.generateRandom(length);
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u4ea7\u751f\u968f\u673a\u6570\u9519\u8bef: " + ex.getMessage());
        }
    }

    public DeviceInfo getDeviceInfo() throws CryptoException {
        try {
            byte[] output = SDSCmd.getDeviceInfo();
            DeviceInfo info = new DeviceInfo();
            info.decode(output);
            return info;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u4ea7\u751f\u968f\u673a\u6570\u9519\u8bef: " + ex.getMessage());
        }
    }

    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        int keyUsage = 65792;
        if (kpType == 1) {
            keyUsage = 66048;
        }
        try {
            byte[] pubKeyData = SDSCmd.exportPublicKey(keyIndex, keyUsage);
            IRSArefPublicKey publicKey = null;
            publicKey = pubKeyData.length == RSArefPublicKey.sizeof() ? new RSArefPublicKey() : new ExRSArefPublicKey();
            publicKey.decode(pubKeyData);
            return publicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5bfc\u51faRSA(" + keyIndex + "\u53f7)" + this.toKpName(kpType) + "\u9519\u8bef: " + ex.getMessage());
        }
    }

    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("\u975e\u6cd5\u7684RSA\u5bc6\u94a5\u6a21\u957f( " + keysize + " )");
        }
        try {
            ByteKeyPair keypair = SDSCmd.generateKeyPair(keysize, 65536);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            IRSArefPublicKey publicKey = null;
            IRSArefPrivateKey privateKey = null;
            if (pubKeyData.length == RSArefPublicKey.sizeof()) {
                publicKey = new RSArefPublicKey();
                privateKey = new RSArefPrivateKey();
            } else {
                publicKey = new ExRSArefPublicKey();
                privateKey = new ExRSArefPrivateKey();
            }
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new RSArefKeyPair(publicKey, privateKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u4ea7\u751f( " + keysize + "\u4f4d )RSA\u5bc6\u94a5\u5bf9\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] rsaPrivateKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7: " + keyIndex);
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        int keyUsage = 65792;
        if (kpType == 1) {
            keyUsage = 66048;
        }
        try {
            byte[] output = SDSCmd.rsaPrivateKeyOperation(keyIndex, keyUsage, null, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8RSA( " + keyIndex + "\u53f7 )\u79c1\u94a5\u8fd0\u7b97\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] rsaPublicKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7: " + keyIndex);
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        IRSArefPublicKey refPublicKey = this.getRSAPublicKey(keyIndex, kpType);
        if (refPublicKey.getBits() >> 3 != input.length) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u957f\u5ea6\u4e0d\u7b49\u4e8e\u516c\u94a5\u6a21\u957f, \u516c\u94a5\u6a21\u957f:\u8fd0\u7b97\u6570\u636e( " + (refPublicKey.getBits() >> 3) + ":" + input.length + " )");
        }
        int keyUsage = 65792;
        if (kpType == 1) {
            keyUsage = 66048;
        }
        try {
            byte[] output = SDSCmd.rsaPublicKeyOperation(keyIndex, keyUsage, null, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8RSA( " + keyIndex + "\u53f7 )\u516c\u94a5\u8fd0\u7b97\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        if (refPublicKey.getBits() >> 3 != input.length) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u957f\u5ea6\u4e0d\u7b49\u4e8e\u516c\u94a5\u6a21\u957f, \u516c\u94a5\u6a21\u957f:\u8fd0\u7b97\u6570\u636e( " + (refPublicKey.getBits() >> 3) + ":" + input.length + " )");
        }
        try {
            byte[] output = SDSCmd.rsaPublicKeyOperation(0, 0, refPublicKey, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u9001RSA\u516c\u94a5\u8fd0\u7b97\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u4e3a\u7a7a");
        }
        if (refPrivateKey.getBits() >> 3 != input.length) {
            throw new CryptoException("\u8fd0\u7b97\u6570\u636e\u957f\u5ea6\u4e0d\u7b49\u4e8e\u516c\u94a5\u6a21\u957f, \u516c\u94a5\u6a21\u957f:\u8fd0\u7b97\u6570\u636e( " + (refPrivateKey.getBits() >> 3) + ":" + input.length + " )");
        }
        try {
            byte[] output = SDSCmd.rsaPrivateKeyOperation(0, 0, refPrivateKey, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u9001RSA\u79c1\u94a5\u8fd0\u7b97\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refPublicKey getSM2PublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        int keyUsage = 131328;
        if (kpType == 1) {
            keyUsage = 132096;
        }
        try {
            byte[] pubKeyData = SDSCmd.exportPublicKey(keyIndex, keyUsage);
            SM2refPublicKey refPublicKey = new SM2refPublicKey();
            refPublicKey.decode(pubKeyData);
            return refPublicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5bfc\u51faSM2(" + keyIndex + "\u53f7)" + this.toKpName(kpType) + "\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("\u975e\u6cd5\u7684SM2\u5bc6\u94a5\u6a21\u957f( " + keysize + " )");
        }
        try {
            ByteKeyPair keypair = SDSCmd.generateKeyPair(keysize, 131072);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            SM2refPublicKey publicKey = new SM2refPublicKey();
            SM2refPrivateKey privateKey = new SM2refPrivateKey();
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new SM2refKeyPair(publicKey, privateKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u4ea7\u751f( " + keysize + "\u4f4d )SM2\u5bc6\u94a5\u5bf9\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] sm2Decrypt(int keyIndex, int kpType, SM2refCipher refCipher) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        if (refCipher == null) {
            throw new CryptoException("\u5bc6\u6587\u4e3a\u7a7a");
        }
        int keyUsage = 131328;
        if (kpType == 1) {
            keyUsage = 132096;
        }
        try {
            byte[] output = SDSCmd.sm2Decrypt(keyUsage, keyIndex, null, refCipher);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8SM2( " + keyIndex + "\u53f7 )\u89e3\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, SM2refCipher refCipher) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (refCipher == null) {
            throw new CryptoException("\u5bc6\u6587\u4e3a\u7a7a");
        }
        int keyUsage = 131328;
        try {
            byte[] output = SDSCmd.sm2Decrypt(keyUsage, 0, refPrivateKey, refCipher);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u90e8SM2\u89e3\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refCipher sm2Encrypt(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b( " + kpType + " )");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u4e3a\u7a7a");
        }
        int keyUsage = 131328;
        if (kpType == 1) {
            keyUsage = 132096;
        }
        try {
            SM2refCipher refCipher = SDSCmd.sm2Encrypt(keyUsage, keyIndex, null, input);
            return refCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8SM2( " + keyIndex + "\u53f7 )\u52a0\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refCipher sm2Encrypt(SM2refPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u4e3a\u7a7a");
        }
        if (input.length > 136) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u592a\u957f\u4e0d\u652f\u6301( " + input.length + " )");
        }
        int keyUsage = 131328;
        try {
            SM2refCipher refCipher = SDSCmd.sm2Encrypt(keyUsage, 0, refPublicKey, input);
            return refCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u90e8SM2\u52a0\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refSignature sm2Sign(int keyIndex, byte[] input) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        int keyUsage = 131328;
        try {
            SM2refSignature refSig = SDSCmd.sm2Sign(keyUsage, keyIndex, null, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8SM2( " + keyIndex + "\u53f7 )\u7b7e\u540d\u9519\u8bef: " + ex.getMessage());
        }
    }

    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        int keyUsage = 131328;
        try {
            SM2refSignature refSig = SDSCmd.sm2Sign(keyUsage, 0, refPrivateKey, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u90e8SM2\u7b7e\u540d\u9519\u8bef: " + ex.getMessage());
        }
    }

    public boolean sm2Verify(int keyIndex, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        if (refSig == null) {
            throw new CryptoException("\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        int keyUsage = 131328;
        try {
            boolean flag = SDSCmd.sm2Verify(keyUsage, keyIndex, null, input, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8SM2( " + keyIndex + "\u53f7 )\u9a8c\u7b7e\u9519\u8bef: " + ex.getMessage());
        }
    }

    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
        }
        if (input.length != 32) {
            throw new CryptoException("\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u9519\u8bef( " + input.length + " )");
        }
        if (refSig == null) {
            throw new CryptoException("\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        int keyUsage = 131328;
        try {
            boolean flag = SDSCmd.sm2Verify(keyUsage, 0, refPublicKey, input, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u90e8SM2\u9a8c\u7b7e\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] encrypt(int algoType, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algoType, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            byte[] output = SDSCmd.encrypt(algoType, 0, key, iv, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u9001\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algoType) + " )\u52a0\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] decrypt(int algoType, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algoType, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u5bc6\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            byte[] output = SDSCmd.decrypt(algoType, 0, key, iv, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5916\u9001\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algoType) + " )\u89e3\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] encrypt(int algoType, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algoType, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u660e\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            byte[] output = SDSCmd.encrypt(algoType, keyIndex, null, iv, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8( " + keyIndex + "\u53f7 )\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algoType) + " )\u52a0\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public byte[] decrypt(int algoType, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(algoType, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (keyIndex < 1 || keyIndex > 100) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u5bc6\u6587\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            byte[] output = SDSCmd.decrypt(algoType, keyIndex, null, iv, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5185\u90e8( " + keyIndex + "\u53f7 )\u5bf9\u79f0\u5bc6\u94a5( " + this.toAlgoName(algoType) + " )\u89e3\u5bc6\u9519\u8bef: " + ex.getMessage());
        }
    }

    public void rsaImportKeyPair(int keyIndex, int kpType, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
        if (keyIndex < 1 || keyIndex > 50) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7: " + keyIndex);
        }
        if (kpType != 1 && kpType != 2) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u7c7b\u578b: " + kpType);
        }
        if (refPublicKey == null) {
            throw new CryptoException("\u516c\u94a5\u4e3a\u7a7a");
        }
        if (refPrivateKey == null) {
            throw new CryptoException("\u79c1\u94a5\u4e3a\u7a7a");
        }
        keyIndex = kpType == 1 ? (keyIndex *= 2) : keyIndex * 2 - 1;
        try {
            SDSCmd.importKeyPair(65536, keyIndex, refPrivateKey.getBits(), refPublicKey.encode(), refPrivateKey.encode());
        }
        catch (CryptoException ex) {
            throw new CryptoException("\u5bfc\u5165RSA( " + keyIndex + "\u53f7 )" + this.toKpName(kpType) + "\u9519\u8bef: " + ex.getMessage());
        }
    }
}

