/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds;

import com.sansec.device.crypto.CryptoException;

public class SymmAlgo {
    private int blockLen;

    public SymmAlgo(int algId) throws CryptoException {
        switch (algId) {
            case 2049: 
            case 2050: {
                this.blockLen = 8;
                break;
            }
            case 257: 
            case 258: 
            case 513: 
            case 514: 
            case 1025: 
            case 1026: 
            case 8193: 
            case 8194: {
                this.blockLen = 16;
                break;
            }
            default: {
                throw new CryptoException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b( 0x" + Integer.toHexString(algId) + " )");
            }
        }
    }

    protected byte[] newIV() {
        return new byte[this.blockLen];
    }

    public int getBlockLen() {
        return this.blockLen;
    }
}

