/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds;

import com.sansec.device.crypto.CryptoException;

public abstract class UtilDevcie {
    public static final int MAX_LENGTH = 8000;

    protected boolean isECBMode(int algoType) throws CryptoException {
        switch (algoType) {
            case 257: 
            case 513: 
            case 1025: 
            case 2049: 
            case 8193: {
                return true;
            }
            case 258: 
            case 514: 
            case 1026: 
            case 2050: 
            case 8194: {
                return false;
            }
        }
        throw new CryptoException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b( 0x" + Integer.toHexString(algoType) + " )");
    }

    protected byte[] newIV(int algoType) throws CryptoException {
        switch (algoType) {
            case 2050: {
                return new byte[8];
            }
            case 258: 
            case 514: 
            case 1026: 
            case 8194: {
                return new byte[16];
            }
        }
        throw new CryptoException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b( 0x" + Integer.toHexString(algoType) + " )");
    }

    protected void checkAlgoAndIV(int algoType, byte[] iv) throws CryptoException {
        switch (algoType) {
            case 257: 
            case 513: 
            case 1025: 
            case 2049: 
            case 8193: {
                break;
            }
            case 258: 
            case 514: 
            case 1026: 
            case 2050: 
            case 8194: {
                if (iv != null) break;
                throw new CryptoException("CBC\u53cd\u9988\u6a21\u5f0fIV\u4e3a\u7a7a");
            }
            default: {
                throw new CryptoException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b( 0x" + Integer.toHexString(algoType) + " )");
            }
        }
    }

    protected String toAlgoName(int algoType) {
        switch (algoType) {
            case 2049: 
            case 2050: {
                return "3DES";
            }
            case 1025: 
            case 1026: {
                return "AES";
            }
            case 257: 
            case 258: {
                return "SM1";
            }
            case 8193: 
            case 8194: {
                return "SM4";
            }
            case 513: 
            case 514: {
                return "SSF33";
            }
        }
        return "UNKNOWN";
    }

    protected String toKpName(int keyType) {
        if (keyType == 1) {
            return "\u52a0\u5bc6\u5bc6\u94a5\u5bf9";
        }
        return "\u7b7e\u540d\u5bc6\u94a5\u5bf9";
    }
}

