/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds.cmd;

import com.sansec.device.bean.ByteKeyPair;
import com.sansec.device.bean.GlobalData;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.socket.NetCommunication;
import com.sansec.device.socket.bean.Request;
import com.sansec.device.socket.bean.Response;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class SDSCmd {
    static final int SWC_GET_DEVICE_INFO = 131073;
    static final int SWC_GEN_RANDOM = 131074;
    static final int SWC_GET_PRI_KEY_ACCESS = 131075;
    static final int SWC_REL_PRI_KEY_ACCESS = 131076;
    static final int SWC_GET_KEY_STATUS = 131077;
    static final int SWC_LOG_OUT = 65536;
    static final int SWC_EXP_PUB_KEY = 262145;
    static final int SWC_GEN_KEY_PAIR = 262146;
    static final int SWC_GEN_KEY_WITH_PUK = 262147;
    static final int SWC_IMP_KEY_WITH_PRK = 262148;
    static final int SWC_EXG_DIGIT_ENVELOP = 262149;
    static final int SWC_GEN_AGMT_DATA = 262150;
    static final int SWC_GEN_AGMT_KEY = 262151;
    static final int SWC_GEN_AGMT_D_AND_K = 262152;
    static final int SWC_IMPORT_KEY = 262153;
    static final int SWC_DESTROY_KEY = 262154;
    static final int SWC_GEN_KEY_WITH_KEK = 262155;
    static final int SWC_IMP_KEY_WITH_KEK = 262156;
    static final int SWC_GET_KEY_HANDLE = 262157;
    static final int SWC_GEN_INT_KEY_PAIR = 262158;
    static final int SWC_IMP_KEY_PAIR = 262159;
    static final int SWC_SET_SK_PWD = 262160;
    static final int SWC_GEN_KEK = 262161;
    static final int SWC_IMP_KEK = 262162;
    static final int SWC_RSA_PUB_KEY_OPT = 524289;
    static final int SWC_RSA_PRI_KEY_OPT = 524290;
    static final int SWC_ECC_SIGN = 524291;
    static final int SWC_ECC_VERIFY = 524292;
    static final int SWC_ECC_ENCRYPT = 524293;
    static final int SWC_ECC_DECRYPT = 524294;
    static final int SWC_SYMM_ENCRYPT = 0x100001;
    static final int SWC_SYMM_DECRYPT = 0x100002;
    static final int SWC_HASH_INIT = 0x200001;
    static final int SWC_HASH_UPDATE = 0x200002;
    static final int SWC_HASH_FINAL = 0x200003;
    static final int SWC_HASH_SIGNAL = 0x200004;
    static Logger logger = GlobalData.logger;

    public static byte[] getDeviceInfo() throws CryptoException {
        Request request = new Request(131073);
        Response response = null;
        try {
            NetCommunication net = new NetCommunication();
            response = net.socketCommunication(request);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        if (response.getErrorCode() != 0) {
            throw new CryptoException("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u9519\u8bef: 0x" + Integer.toHexString(response.getErrorCode()));
        }
        int infoLen = Bytes.bytes2int(response.getData());
        byte[] info = SDSCmd.getBytes(response.getData(), 4, infoLen);
        return info;
    }

    public static byte[] generateRandom(int length) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(length));
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(131074, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
        int rndLen = Bytes.bytes2int(response.getData());
        byte[] rnd = SDSCmd.getBytes(response.getData(), 4, rndLen);
        return rnd;
    }

    public static byte[] exportPublicKey(int keyIndex, int kpTypeCode) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(kpTypeCode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262145, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
        int pubKeyLen = Bytes.bytes2int(response.getData());
        byte[] pubKeyData = SDSCmd.getBytes(response.getData(), 4, pubKeyLen);
        return pubKeyData;
    }

    public static ByteKeyPair generateKeyPair(int keyBits, int kpTypeCode) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(kpTypeCode));
            out.write(Bytes.int2bytes(keyBits));
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262146, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
        int pubKeyLen = Bytes.bytes2int(response.getData());
        byte[] pubKeyData = SDSCmd.getBytes(response.getData(), 4, pubKeyLen);
        int priKeyLen = Bytes.bytes2int(response.getData(), 4 + pubKeyLen);
        byte[] priKeyData = SDSCmd.getBytes(response.getData(), 4 + pubKeyLen + 4, priKeyLen);
        return new ByteKeyPair(pubKeyData, priKeyData);
    }

    public static byte[] rsaPublicKeyOperation(int keyIndex, int keyUsage, IRSArefPublicKey publicKey, byte[] dataInput) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (publicKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(Bytes.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524289, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("RSA\u516c\u94a5\u8fd0\u7b97: 0x" + Integer.toHexString(response.getErrorCode()));
        }
        int dataLen = Bytes.bytes2int(response.getData());
        byte[] dataOutput = SDSCmd.getBytes(response.getData(), 4, dataLen);
        return dataOutput;
    }

    public static byte[] rsaPrivateKeyOperation(int keyIndex, int keyUsage, IRSArefPrivateKey privateKey, byte[] input) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (privateKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(Bytes.int2bytes(input.length));
            out.write(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524290, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("RSA\u516c\u94a5\u8fd0\u7b97: 0x" + Integer.toHexString(response.getErrorCode()));
        }
        int dataLen = Bytes.bytes2int(response.getData());
        byte[] dataOutput = SDSCmd.getBytes(response.getData(), 4, dataLen);
        return dataOutput;
    }

    public static SM2refCipher sm2Encrypt(int keyUsage, int keyIndex, SM2refPublicKey publicKey, byte[] dataInput) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (publicKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(Bytes.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524293, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("SM2\u52a0\u5bc6\u8fd0\u7b97: " + response.getErrorInfo());
        }
        int dataLen = Bytes.bytes2int(response.getData());
        SM2refCipher refCipher = new SM2refCipher();
        byte[] bytes = SDSCmd.getBytes(response.getData(), 4, dataLen);
        refCipher.decode(bytes);
        if (refCipher.getCLength() != dataInput.length) {
            throw new RuntimeException();
        }
        return refCipher;
    }

    public static byte[] sm2Decrypt(int keyUsage, int keyIndex, SM2refPrivateKey privateKey, SM2refCipher cipher) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (privateKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(Bytes.int2bytes(cipher.size()));
            out.write(cipher.encode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524294, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("SM2\u89e3\u5bc6\u8fd0\u7b97: " + response.getErrorInfo());
        }
        int dataLength = Bytes.bytes2int(response.getData());
        byte[] dataOutput = SDSCmd.getBytes(response.getData(), 4, dataLength);
        return dataOutput;
    }

    public static SM2refSignature sm2Sign(int keyUsage, int keyIndex, SM2refPrivateKey privateKey, byte[] hash) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (privateKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(Bytes.int2bytes(hash.length));
            out.write(hash);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524291, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("SM2\u7b7e\u540d\u8fd0\u7b97: " + response.getErrorInfo());
        }
        int dataLen = Bytes.bytes2int(response.getData());
        byte[] data = SDSCmd.getBytes(response.getData(), 4, dataLen);
        SM2refSignature sigData = new SM2refSignature();
        sigData.decode(data);
        return sigData;
    }

    public static boolean sm2Verify(int keyUsage, int keyIndex, SM2refPublicKey publicKey, byte[] hash, SM2refSignature sigData) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(keyUsage));
            out.write(Bytes.int2bytes(0));
            if (publicKey == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(Bytes.int2bytes(hash.length));
            out.write(hash);
            out.write(Bytes.int2bytes(sigData.size()));
            out.write(sigData.encode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524292, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("SM2\u9a8c\u7b7e\u8fd0\u7b97: " + response.getErrorInfo());
        }
        return true;
    }

    public static byte[] encrypt(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput) throws CryptoException {
        int type = GlobalData.KEY_TYPE_EXTERNAL_KEY;
        if (key == null) {
            type = GlobalData.KEY_TYPE_KEK;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(algoType));
            out.write(Bytes.int2bytes(type));
            out.write(Bytes.int2bytes(keyIndex));
            if (key == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(iv.length));
                out.write(iv);
            }
            out.write(Bytes.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100001, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("\u5bf9\u79f0\u52a0\u5bc6\u8fd0\u7b97: " + response.getErrorInfo());
        }
        int dataLength = Bytes.bytes2int(response.getData());
        byte[] dataOutput = SDSCmd.getBytes(response.getData(), 4, dataLength);
        return dataOutput;
    }

    public static byte[] decrypt(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput) throws CryptoException {
        int type = GlobalData.KEY_TYPE_EXTERNAL_KEY;
        if (key == null) {
            type = GlobalData.KEY_TYPE_KEK;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(algoType));
            out.write(Bytes.int2bytes(type));
            out.write(Bytes.int2bytes(keyIndex));
            if (key == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(Bytes.int2bytes(0));
            } else {
                out.write(Bytes.int2bytes(iv.length));
                out.write(iv);
            }
            out.write(Bytes.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100002, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("\u5bf9\u79f0\u89e3\u5bc6\u8fd0\u7b97: " + response.getErrorInfo());
        }
        int dataLength = Bytes.bytes2int(response.getData());
        byte[] dataOutput = SDSCmd.getBytes(response.getData(), 4, dataLength);
        return dataOutput;
    }

    public static void importKeyPair(int algoType, int keyIndex, int keysize, byte[] pubkey, byte[] prikey) throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Bytes.int2bytes(algoType));
            out.write(Bytes.int2bytes(keysize));
            out.write(Bytes.int2bytes(keyIndex));
            out.write(Bytes.int2bytes(pubkey.length));
            out.write(pubkey);
            out.write(Bytes.int2bytes(prikey.length));
            out.write(prikey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262159, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
    }

    private static byte[] getBytes(byte[] bytesResponse, int offset, int length) {
        return Bytes.subbytes(bytesResponse, offset, length);
    }
}

