/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds.local;

import com.sansec.device.sds.local.JARLibUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipFile;

public class Device {
    public static void main(String[] args) {
        System.out.println(System.getProperty("java.library.path"));
    }

    static void loadLib(ZipFile zf, String filename) {
        try {
            File f = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + filename.substring(filename.lastIndexOf("/")));
            if (!f.exists()) {
                InputStream in = zf.getInputStream(zf.getEntry(filename));
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                int len = -1;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
                JARLibUtil.addExec(f.getAbsolutePath());
            }
            System.load(f.getAbsolutePath());
            boolean flag = f.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static void initializeLib() {
        String provider = "device";
        try {
            System.loadLibrary(provider);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("native lib( " + provider + " ) not found in java.library.path: " + System.getProperty("java.library.path"));
            throw new UnsatisfiedLinkError("native lib( " + provider + " ) not found in java.library.path: " + System.getProperty("java.library.path") + "\n" + e);
        }
    }

    public native byte[] getVerision();

    public native int openDevice();

    public native int coseDevice();

    public native byte[] getDeviceInfo();

    public native byte[] generateRandom(int var1);

    public native byte[] getKeyStatus(int var1);

    public native byte[] rsaGenerateKeyPair(int var1);

    public native byte[] rsaExportPublicKey(int var1, int var2);

    public native byte[] sm2GenerateKeyPair(int var1);

    public native byte[] sm2ExportPublicKey(int var1, int var2);

    public native byte[] getSymmKeyHandle(int var1);

    public native byte[] importKey(byte[] var1);

    public native byte[] destroyKey(byte[] var1);

    public native byte[] deleteKey(byte[] var1);

    public native byte[] rsaExternalPublicKeyOperation(byte[] var1, byte[] var2);

    public native byte[] rsaExternalPrivateKeyOperation(byte[] var1, byte[] var2);

    public native byte[] rsaInternalPublicKeyOperation(int var1, int var2, byte[] var3);

    public native byte[] rsaInternalPrivateKeyOperation(int var1, int var2, byte[] var3);

    public native byte[] sm2InternalEncrypt(int var1, int var2, byte[] var3);

    public native byte[] sm2InternalDecrypt(int var1, int var2, byte[] var3);

    public native byte[] sm2InternalSign(int var1, int var2, byte[] var3);

    public native byte[] sm2InternalVerify(int var1, int var2, byte[] var3, byte[] var4);

    public native byte[] sm2ExternalEncrypt(byte[] var1, byte[] var2);

    public native byte[] sm2ExternalDecrypt(byte[] var1, byte[] var2);

    public native byte[] sm2ExternalSign(byte[] var1, byte[] var2);

    public native byte[] sm2ExternalVerify(byte[] var1, byte[] var2, byte[] var3);

    public native byte[] encrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native byte[] decrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native byte[] externalEncrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native byte[] externalDecrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native byte[] internalEncrypt(int var1, int var2, byte[] var3, byte[] var4);

    public native byte[] internalDecrypt(int var1, int var2, byte[] var3, byte[] var4);

    public native byte[] importKeyPair(int var1, int var2, byte[] var3, byte[] var4);

    public native byte[] backup(byte[] var1);

    public native byte[] recovery(byte[] var1, byte[] var2);

    public native byte[] generateRsaKeyPair(int var1, int var2, int var3);

    public native byte[] generateSm2KeyPair(int var1, int var2);

    public native byte[] login(byte[] var1);

    public native byte[] initDevice(int var1);

    public native byte[] initPassword(byte[] var1);
}

