/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.sds.local;

import java.io.IOException;

public class JARLibUtil {
    public static String getJniLibName() {
        int jvmArch = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        if (JARLibUtil.isWindowsOS()) {
            switch (jvmArch) {
                case 32: {
                    return "lib/win32/device.dll";
                }
                case 64: {
                    return "lib/win64/device.dll";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        if (JARLibUtil.isLinuxOS()) {
            switch (jvmArch) {
                case 32: {
                    return "lib/linux32/libdevice.so";
                }
                case 64: {
                    return "lib/linux64/libdevice.so";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf(System.getProperty(\"os.name\") = " + System.getProperty("os.name") + ")");
    }

    public static String getSwsdsLibName() {
        int jvmArch = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        if (JARLibUtil.isWindowsOS()) {
            switch (jvmArch) {
                case 32: {
                    return "lib/win32/swsds.dll";
                }
                case 64: {
                    return "lib/win64/swsds.dll";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        if (JARLibUtil.isLinuxOS()) {
            switch (jvmArch) {
                case 32: {
                    return "lib/linux32/libswsds.so";
                }
                case 64: {
                    return "lib/linux64/libswsds.so";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf(System.getProperty(\"os.name\") = " + System.getProperty("os.name") + ")");
    }

    public static void addExec(String filename) throws IOException {
        String cmd = "chmod a+x " + filename;
        Process p = Runtime.getRuntime().exec(cmd);
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static boolean isLinuxOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("linux")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }
}

