/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.socket;

import com.sansec.device.crypto.CryptoException;
import com.sansec.device.socket.HSMSession;
import java.util.ArrayList;
import java.util.List;

public class HSMPool {
    private List sessions = new ArrayList();
    private static HSMPool pool = new HSMPool();
    private boolean initialize = false;

    private HSMPool() {
    }

    public static HSMPool getPool() {
        return pool;
    }

    public synchronized void initialize(int poolsize, List allHsm, int connectTimeout, int serviceTimeout) throws CryptoException {
        if (!this.initialize) {
            try {
                HSMSession session = new HSMSession(allHsm, connectTimeout, serviceTimeout);
                this.sessions.add(session);
            }
            catch (Exception e) {
                HSMSession session = new HSMSession(allHsm, connectTimeout, serviceTimeout);
                this.sessions.add(session);
            }
            this.initialize = true;
            try {
                new Thread(new Pool(poolsize, allHsm, connectTimeout, serviceTimeout)).start();
            }
            catch (Exception e) {
                throw new CryptoException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HSMSession getSession() {
        HSMSession session = null;
        List list = this.sessions;
        synchronized (list) {
            while (true) {
                if (this.sessions.size() != 0) {
                    return (HSMSession)this.sessions.remove(0);
                }
                try {
                    this.sessions.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(HSMSession session) {
        List list = this.sessions;
        synchronized (list) {
            this.sessions.add(session);
            if (this.sessions.size() == 1) {
                this.sessions.notifyAll();
            }
        }
    }

    public synchronized boolean isInitialize() {
        return this.initialize;
    }

    private class Pool
    implements Runnable {
        private int poolsize;
        private int connectTimeout;
        private int serviceTimeout;
        private List allHsm;

        public Pool(int poolsize, List allHsm, int connectTimeout, int serviceTimeout) {
            this.poolsize = poolsize;
            this.connectTimeout = connectTimeout;
            this.serviceTimeout = serviceTimeout;
            this.allHsm = allHsm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HSMPool hSMPool = pool;
            synchronized (hSMPool) {
                int i = 0;
                while (i < this.poolsize - 1) {
                    try {
                        HSMSession session = new HSMSession(this.allHsm, this.connectTimeout, this.serviceTimeout);
                        HSMPool.this.sessions.add(session);
                    }
                    catch (CryptoException ex) {
                        throw new RuntimeException(ex);
                    }
                    ++i;
                }
            }
        }
    }
}

