/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.socket;

import com.sansec.device.bean.GlobalData;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.socket.HSMSocket;
import com.sansec.device.socket.bean.HSMInfo;
import java.util.List;
import java.util.logging.Logger;

public class HSMSession {
    private Logger logger = GlobalData.logger;
    private HSMSocket[] sockets = null;
    private int cnt = 0;

    public HSMSession(List allHsm, int connectTimeout, int serviceTimeout) throws CryptoException {
        this.sockets = new HSMSocket[allHsm.size()];
        boolean connect = false;
        int i = 0;
        while (i < allHsm.size()) {
            HSMInfo info = (HSMInfo)allHsm.get(i);
            try {
                this.sockets[i] = new HSMSocket(info.getIp(), info.getConnectPwd(), info.getPort(), connectTimeout, serviceTimeout);
                this.sockets[i].login();
                connect = true;
            }
            catch (Exception e) {
                this.logger.warning("\u521d\u59cb\u5316 -- IP\u5730\u5740( " + info.getIp() + " )\u5bc6\u7801\u673a\u8fde\u63a5\u4e0d\u4e0a");
            }
            ++i;
        }
        if (!connect) {
            throw new CryptoException("\u521d\u59cb\u5316 -- \u6240\u6709\u5bc6\u7801\u673a\u8fde\u63a5\u4e0d\u4e0a");
        }
    }

    public void repair() throws CryptoException {
        this.logger.fine("repair");
        int i = 0;
        while (i < this.getSize()) {
            this.sockets[i].repair();
            ++i;
        }
        this.logger.fine("repair->return");
    }

    public HSMSocket getHsmSocket() {
        HSMSocket socket = null;
        socket = this.sockets[this.cnt];
        this.cnt = (this.cnt + 1) % this.getSize();
        return socket;
    }

    public int getSize() {
        return this.sockets.length;
    }

    public void close() {
        int i = 0;
        while (i < this.getSize()) {
            this.sockets[i].close();
            ++i;
        }
    }
}

