/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.socket;

import com.sansec.device.bean.GlobalData;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.socket.bean.ReqLogin;
import com.sansec.device.socket.bean.RespHeader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Logger;

public class HSMSocket {
    private Logger logger = GlobalData.logger;
    private String ip;
    private String passwd;
    private int port;
    private int connectTimeout;
    private int serviceTimeout;
    private Socket socket;
    private OutputStream out;
    private InputStream in;

    public HSMSocket(String ip, String passwd, int port, int connectTimeout, int serviceTimeout) throws CryptoException {
        this.ip = ip;
        this.passwd = passwd;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.serviceTimeout = serviceTimeout;
    }

    public void repair() throws CryptoException {
        this.logger.info("repair");
        this.close();
        this.login();
        this.logger.info("repair->return");
    }

    public byte[] sendAndReceive(byte[] command) throws CryptoException {
        try {
            this.out.write(command);
            this.out.flush();
        }
        catch (Exception e) {
            throw new CryptoException("\u53d1\u9001\u547d\u4ee4\u5931\u8d25[ " + e.getMessage() + " ]");
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        RespHeader header = null;
        int retLen = 0;
        try {
            byte[] buf = new byte[12];
            retLen = this.in.read(buf, 0, buf.length);
            if (buf.length != retLen) {
                throw new CryptoException("\u8bfb\u53d6\u8fd4\u56de\u5934\u9519\u8bef");
            }
            outStream.write(buf);
            header = new RespHeader(buf);
            int iLeftLen = header.getTotalLength() - header.size();
            buf = new byte[iLeftLen > GlobalData.MAX_BUFFER_SIZE ? GlobalData.MAX_BUFFER_SIZE : iLeftLen];
            while (iLeftLen > 0) {
                retLen = this.in.read(buf, 0, buf.length);
                if (retLen == -1) {
                    throw new CryptoException("\u8bfb\u53d6\u54cd\u5e94\u9519\u8bef");
                }
                outStream.write(buf, 0, retLen);
                iLeftLen -= retLen;
            }
        }
        catch (Exception e) {
            throw new CryptoException("\u8bfb\u53d6\u8fd4\u56de\u54cd\u5e94\u5931\u8d25[ " + e.getMessage() + " ]");
        }
        return outStream.toByteArray();
    }

    public void login() throws CryptoException {
        ReqLogin lrh = new ReqLogin();
        lrh.setConnectPwd(this.passwd.getBytes());
        byte[] revBuffer = null;
        byte[] sendBuffer = lrh.encode();
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.ip, this.port), this.connectTimeout * 1000);
            this.socket.setSoTimeout(this.serviceTimeout * 1000);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            revBuffer = this.sendAndReceive(sendBuffer);
        }
        catch (Exception e) {
            this.close();
            throw new CryptoException(e);
        }
        RespHeader header = new RespHeader(revBuffer);
        if (header.getErrorCode() != 0) {
            this.close();
            throw new CryptoException("Socket[" + this + "] \u8fd4\u56de[" + header.getErrorInfo() + "]");
        }
    }

    public String getIp() {
        return this.ip;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "" + this.socket;
    }
}

