/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.socket;

import com.sansec.device.bean.GlobalData;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.socket.HSMPool;
import com.sansec.device.socket.HSMSession;
import com.sansec.device.socket.HSMSocket;
import com.sansec.device.socket.SocketRepairException;
import com.sansec.device.socket.bean.Request;
import com.sansec.device.socket.bean.Response;
import java.util.logging.Logger;

public class NetCommunication {
    Logger logger = GlobalData.logger;
    private int[] resHeader = new int[3];
    private byte[] resParams = null;
    private HSMPool pool = HSMPool.getPool();

    public int[] getResHeader() {
        return this.resHeader;
    }

    public byte[] getResParams() {
        return this.resParams;
    }

    public int getReturenValue() {
        return this.resHeader[2];
    }

    public byte[] getResParams(int offset, int len) {
        if (offset < 0) {
            return null;
        }
        if (this.resParams == null || offset + len > this.resParams.length) {
            return null;
        }
        byte[] datas = new byte[len];
        System.arraycopy(this.resParams, offset, datas, 0, len);
        return datas;
    }

    public Response socketCommunication(Request request) throws CryptoException {
        Response response;
        block23: {
            response = null;
            HSMSession session = this.pool.getSession();
            int size = session.getSize();
            try {
                if (request.forSync()) {
                    int i = 0;
                    while (i < size) {
                        block22: {
                            HSMSocket hsmSocket = session.getHsmSocket();
                            byte[] revBuffer = null;
                            try {
                                revBuffer = hsmSocket.sendAndReceive(request.encode());
                            }
                            catch (CryptoException ex) {
                                response = this.reSocketCommunication(session, hsmSocket, request);
                                break block22;
                            }
                            response = new Response(revBuffer);
                            if (response.getErrorCode() != 0) {
                                throw new CryptoException(hsmSocket + " Return( " + response.getErrorInfo() + " )");
                            }
                            if (response.getTaskSN() != request.getnTaskSN()) {
                                response = this.reSocketCommunication(session, hsmSocket, request);
                            }
                        }
                        ++i;
                    }
                    break block23;
                }
                int i = 0;
                while (i < size) {
                    HSMSocket hsmSocket;
                    try {
                        hsmSocket = session.getHsmSocket();
                        byte[] revBuffer = null;
                        try {
                            revBuffer = hsmSocket.sendAndReceive(request.encode());
                        }
                        catch (CryptoException ex) {
                            Response response2 = this.reSocketCommunication(session, hsmSocket, request);
                            this.pool.release(session);
                            return response2;
                        }
                        response = new Response(revBuffer);
                    }
                    catch (SocketRepairException ex) {
                        try {
                            if (i == size - 1) {
                                throw new CryptoException("\u8fd0\u7b97 -- \u6240\u6709\u5bc6\u7801\u673a\u8fde\u63a5\u4e0d\u4e0a");
                            }
                            ++i;
                            continue;
                        }
                        catch (Exception e) {
                            throw new CryptoException(e.getMessage());
                        }
                    }
                    if (response.getErrorCode() != 0) {
                        throw new CryptoException(hsmSocket + " Return( " + response.getErrorInfo() + " )");
                    }
                    if (response.getTaskSN() != request.getnTaskSN()) {
                        Response response3 = this.reSocketCommunication(session, hsmSocket, request);
                        return response3;
                    }
                    Response response4 = response;
                    return response4;
                }
            }
            finally {
                this.pool.release(session);
            }
        }
        return response;
    }

    private Response reSocketCommunication(HSMSession session, HSMSocket hsmSocket, Request request) throws CryptoException, SocketRepairException {
        try {
            hsmSocket.repair();
        }
        catch (CryptoException ex) {
            this.logger.warning("IP( " + hsmSocket.getIp() + " )\u4fee\u590d\u5931\u8d25: " + ex.getMessage());
            throw new SocketRepairException("IP( " + hsmSocket.getIp() + " )\u4fee\u590d\u5931\u8d25: " + ex.getMessage());
        }
        byte[] revBuffer = hsmSocket.sendAndReceive(request.encode());
        Response response = new Response(revBuffer);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(hsmSocket + " Return( " + response.getErrorInfo() + " )");
        }
        if (response.getTaskSN() != request.getnTaskSN()) {
            throw new CryptoException(hsmSocket + " task not equal");
        }
        return response;
    }
}

