/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DEROutputStream;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x509.TBSCertificateStructure;
import com.sansec.asn1.x509.Time;
import com.sansec.asn1.x509.V3TBSCertificateGenerator;
import com.sansec.asn1.x509.X509CertificateStructure;
import com.sansec.asn1.x509.X509Extension;
import com.sansec.asn1.x509.X509Extensions;
import com.sansec.asn1.x509.X509Name;
import com.sansec.jce.provider.X509CertificateObject;
import com.sansec.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class X509V3CertificateGenerator {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private Hashtable extensions = null;
    private Vector extOrdering = null;
    private static Hashtable algorithms = new Hashtable();

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
    }

    public void reset() {
        this.tbsGen = new V3TBSCertificateGenerator();
        this.extensions = null;
        this.extOrdering = null;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.tbsGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setIssuerDN(X509Name issuer) {
        this.tbsGen.setIssuer(issuer);
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setSubjectDN(X509Name subject) {
        this.tbsGen.setSubject(subject);
    }

    public void setPublicKey(PublicKey key) {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(key.getEncoded())).readObject()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to process key - " + e.toString());
        }
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sigOID = (DERObjectIdentifier)algorithms.get(Strings.toUpperCase(signatureAlgorithm));
        if (this.sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = new AlgorithmIdentifier(this.sigOID, new DERNull());
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void addExtension(String OID, boolean critical, DEREncodable value) {
        this.addExtension(new DERObjectIdentifier(OID), critical, value);
    }

    public void addExtension(DERObjectIdentifier OID, boolean critical, DEREncodable value) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error encoding value: " + e);
        }
        this.addExtension(OID, critical, bOut.toByteArray());
    }

    public void addExtension(String OID, boolean critical, byte[] value) {
        this.addExtension(new DERObjectIdentifier(OID), critical, value);
    }

    public void addExtension(DERObjectIdentifier OID, boolean critical, byte[] value) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        this.extensions.put(OID, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
        this.extOrdering.addElement(OID);
    }

    public X509Certificate generateX509Certificate(PrivateKey key) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(key, "SwxaJCE", null);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("SwxaJCE provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey key, SecureRandom random) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(key, "SwxaJCE", random);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("SwxaJCE provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509Certificate(key, provider, null);
    }

    public X509Certificate generateX509Certificate(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        Signature sig = null;
        if (this.sigOID == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        try {
            sig = Signature.getInstance(this.sigOID.getId(), provider);
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                sig = Signature.getInstance(this.signatureAlgorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("exception creating signature: " + e.toString());
            }
        }
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        if (this.extensions != null) {
            this.tbsGen.setExtensions(new X509Extensions(this.extOrdering, this.extensions));
        }
        TBSCertificateStructure tbsCert = this.tbsGen.generateTBSCertificate();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(tbsCert);
            sig.update(bOut.toByteArray());
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(tbsCert);
            v.add(this.sigAlgId);
            v.add(new DERBitString(sig.sign()));
            return new X509CertificateObject(new X509CertificateStructure(new DERSequence(v)));
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert - " + e);
        }
    }
}

