/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.SM2PrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;

public class JCESM2PrivateKey
implements ECPrivateKey {
    static final long serialVersionUID = -8145849727580266753L;
    private static BigInteger MAX_KEY_INDEX = new BigInteger("50");
    private int keyIndex;
    private BigInteger s;
    private BigInteger x;
    private BigInteger y;

    public int getKeyIndex() {
        return this.keyIndex;
    }

    private void setS(BigInteger s) {
        BigInteger t = s.max(MAX_KEY_INDEX);
        if (!s.equals(t) && s.signum() >= 0) {
            this.keyIndex = s.intValue();
        }
        this.s = s;
    }

    JCESM2PrivateKey(SM2PrivateKeyParameters prikey, SM2PublicKeyParameters pubkey) {
        this.keyIndex = prikey.getKeyIndex();
        this.s = prikey.getD();
        this.x = pubkey.getX();
        this.y = pubkey.getY();
    }

    public JCESM2PrivateKey(ECPrivateKeySpec spec) {
        this.setS(spec.getS());
    }

    public JCESM2PrivateKey(SM2PrivateKeyStructure structure) {
        this.setS(structure.getKey());
        DERBitString publicKeyData = structure.getPublicKey();
        if (publicKeyData != null) {
            SM2PublicKeyStructure pubKey = new SM2PublicKeyStructure(publicKeyData);
            this.x = pubKey.getQ().getAffineX();
            this.y = pubKey.getQ().getAffineY();
        }
    }

    public JCESM2PrivateKey(PrivateKeyInfo info) {
        try {
            SM2PrivateKeyStructure structure = new SM2PrivateKeyStructure((ASN1Sequence)info.getPrivateKey());
            this.setS(structure.getKey());
            DERBitString publicKeyData = structure.getPublicKey();
            if (publicKeyData != null) {
                SM2PublicKeyStructure pubKey = new SM2PublicKeyStructure(publicKeyData);
                this.x = pubKey.getQ().getAffineX();
                this.y = pubKey.getQ().getAffineY();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in SM2 public key");
        }
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        DERBitString pubkey = null;
        if (this.x != null && this.y != null) {
            pubkey = new DERBitString(new SM2PublicKeyStructure(new ECPoint(this.x, this.y)).getPublicKey());
        }
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), new SM2PrivateKeyStructure(this.s, pubkey, null).getDERObject());
        return info.getDEREncoded();
    }

    public int hashCode() {
        return this.getS().hashCode() ^ this.getKeyIndex();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JCESM2PrivateKey)) {
            return false;
        }
        JCESM2PrivateKey key = (JCESM2PrivateKey)o;
        return key.getS().equals(this.s) && this.getKeyIndex() == key.getKeyIndex();
    }

    public String toString() {
        String str = "";
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = System.getProperty("line.separator");
            buf.append("SM2 Private Key").append(nl);
            buf.append("             S: ").append(this.s.toString(16)).append(nl);
            str = buf.toString();
        } else {
            str = "\u5185\u90e8SM2\u79c1\u94a5[ " + this.keyIndex + " ]";
        }
        return str;
    }

    public BigInteger getS() {
        return this.s;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public ECParameterSpec getParams() {
        return null;
    }
}

