/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import com.sansec.jce.provider.KeyIndexWrap;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;

public class JCESM2PublicKey
implements ECPublicKey {
    static final long serialVersionUID = -8145849727580266753L;
    private int keyIndex;
    private ECPoint w;

    public int getKeyIndex() {
        return this.keyIndex;
    }

    JCESM2PublicKey(SM2PublicKeyParameters key) {
        this.keyIndex = key.getKeyIndex();
        this.w = new ECPoint(key.getX(), key.getY());
    }

    public JCESM2PublicKey(ECPublicKeySpec spec) {
        this.w = spec.getW();
        this.keyIndex = KeyIndexWrap.eccUnwrap(spec.getParams());
    }

    public JCESM2PublicKey(SubjectPublicKeyInfo info) {
        try {
            SM2PublicKeyStructure pubKey = new SM2PublicKeyStructure(info.getPublicKeyData());
            this.w = pubKey.getQ();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in SM2 public key");
        }
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), new SM2PublicKeyStructure(this.w).getPublicKey());
        return info.getDEREncoded();
    }

    public int hashCode() {
        return this.getW().hashCode() ^ this.getKeyIndex();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JCESM2PublicKey)) {
            return false;
        }
        JCESM2PublicKey key = (JCESM2PublicKey)o;
        return key.getW().getAffineX().equals(this.w.getAffineX()) && key.getW().getAffineY().equals(this.w.getAffineY()) && this.getKeyIndex() == key.getKeyIndex();
    }

    public String toString() {
        String str = "";
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = System.getProperty("line.separator");
            buf.append("SM2 Public Key").append(nl);
            buf.append("      AffineX: ").append(this.w.getAffineX().toString(16)).append(nl);
            buf.append("      AffineY: ").append(this.w.getAffineY().toString(16)).append(nl);
            str = buf.toString();
        } else {
            str = "\u5185\u90e8SM2\u516c\u94a5[ " + this.keyIndex + " ]";
        }
        return str;
    }

    public ECPoint getW() {
        return this.w;
    }

    public ECParameterSpec getParams() {
        return null;
    }
}

