/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.Digest;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.encodings.OAEPEncoding;
import com.sansec.crypto.encodings.SM2EncryptGBEncoding;
import com.sansec.crypto.encodings.SM2EncryptOldEncoding;
import com.sansec.crypto.engines.SM2EncryptGBEngine;
import com.sansec.crypto.engines.SM2EncryptOldEngine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.jce.provider.JCEDigestUtil;
import com.sansec.jce.provider.JCESM2PrivateKey;
import com.sansec.jce.provider.JCESM2PublicKey;
import com.sansec.jce.provider.SM2Util;
import com.sansec.jce.provider.WrapCipherSpi;
import com.sansec.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class JDKSM2Cipher
extends WrapCipherSpi {
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public JDKSM2Cipher(AsymmetricBlockCipher engine) {
        this.cipher = engine;
    }

    public JDKSM2Cipher(OAEPParameterSpec pSpec) {
        try {
            this.initFromSpec(pSpec);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for ECC block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            out = this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        int i = 0;
        while (i != out.length) {
            output[outputOffset + i] = out[i];
            ++i;
        }
        return out.length;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new RuntimeCryptoException("too much data for ECC block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    private void initFromSpec(OAEPParameterSpec pSpec) throws NoSuchPaddingException {
        MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)pSpec.getMGFParameters();
        Digest digest = JCEDigestUtil.getDigest(mgfParams.getDigestAlgorithm());
        if (digest == null) {
            throw new NoSuchPaddingException("no match on OAEP constructor for digest algorithm: " + mgfParams.getDigestAlgorithm());
        }
        this.cipher = new OAEPEncoding(new SM2EncryptGBEngine(), digest, ((PSource.PSpecified)pSpec.getPSource()).getValue());
        this.paramSpec = pSpec;
    }

    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ECC Cipher not initialised");
        }
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            return k.getW().getAffineX().bitLength();
        }
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            return k.getS().bitLength();
        }
        throw new IllegalArgumentException("not an ECC key!");
    }

    protected int engineGetOutputSize(int inputLen) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ECC Cipher not initialised");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("OAEP", "SwxaJCE");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        OAEPParameterSpec paramSpec = null;
        if (params != null) {
            try {
                paramSpec = params.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + e.toString(), e);
            }
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (params == null || params instanceof OAEPParameterSpec) {
            if (key instanceof JCESM2PublicKey) {
                param = SM2Util.generatePublicKeyParameter((JCESM2PublicKey)key);
            } else if (key instanceof JCESM2PrivateKey) {
                param = SM2Util.generatePrivateKeyParameter((JCESM2PrivateKey)key);
            } else {
                throw new InvalidKeyException("unknown key type passed to ECC");
            }
            if (params != null) {
                OAEPParameterSpec spec = (OAEPParameterSpec)params;
                this.paramSpec = params;
                if (!spec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !spec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                    throw new InvalidAlgorithmParameterException("unknown mask generation function specified");
                }
                if (!(spec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("unkown MGF parameters");
                }
                Digest digest = JCEDigestUtil.getDigest(spec.getDigestAlgorithm());
                if (digest == null) {
                    throw new InvalidAlgorithmParameterException("no match on digest algorithm: " + spec.getDigestAlgorithm());
                }
                MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)spec.getMGFParameters();
                Digest mgfDigest = JCEDigestUtil.getDigest(mgfParams.getDigestAlgorithm());
                if (mgfDigest == null) {
                    throw new InvalidAlgorithmParameterException("no match on MGF digest algorithm: " + mgfParams.getDigestAlgorithm());
                }
                this.cipher = new OAEPEncoding(new SM2EncryptGBEngine(), digest, mgfDigest, ((PSource.PSpecified)spec.getPSource()).getValue());
            }
        } else {
            throw new IllegalArgumentException("unknown parameter type.");
        }
        if (!(this.cipher instanceof SM2EncryptGBEngine)) {
            param = random != null ? new ParametersWithRandom(param, random) : new ParametersWithRandom(param, new SecureRandom());
        }
        switch (opmode) {
            case 1: 
            case 3: {
                if (!(key instanceof JCESM2PublicKey)) {
                    throw new InvalidParameterException("invalid public key try encrypt mode for ECC");
                }
                this.cipher.init(true, param);
                break;
            }
            case 2: 
            case 4: {
                if (!(key instanceof JCESM2PrivateKey)) {
                    throw new InvalidParameterException("invalid private key try decrypte mode for ECC");
                }
                this.cipher.init(false, param);
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + opmode + " passed to ECC");
            }
        }
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Eeeek! " + e.toString(), e);
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String md = Strings.toUpperCase(mode);
        if (md.equals("NONE") || md.equals("ECB")) {
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String pad = Strings.toUpperCase(padding);
        if (!pad.equals("NOPADDING") && !pad.equals("PADDING")) {
            throw new NoSuchPaddingException(String.valueOf(padding) + " unavailable with ECC.");
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        return super.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for ECC block");
        }
        return 0;
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for ECC block");
        }
        return null;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return super.engineWrap(key);
    }

    public static class SM2
    extends JDKSM2Cipher {
        public SM2() {
            super(new SM2EncryptOldEncoding(new SM2EncryptOldEngine()));
        }
    }

    public static class SM2Encoding
    extends JDKSM2Cipher {
        public SM2Encoding() {
            super(new SM2EncryptOldEncoding(new SM2EncryptOldEngine()));
        }
    }

    public static class SM2GBEncoding
    extends JDKSM2Cipher {
        public SM2GBEncoding() {
            super(new SM2EncryptGBEncoding(new SM2EncryptGBEngine()));
        }
    }
}

