/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.SM2SignStructure;
import com.sansec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.MD2Digest;
import com.sansec.crypto.digests.MD4Digest;
import com.sansec.crypto.digests.MD5Digest;
import com.sansec.crypto.digests.RIPEMD128Digest;
import com.sansec.crypto.digests.RIPEMD160Digest;
import com.sansec.crypto.digests.RIPEMD256Digest;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.digests.SHA224Digest;
import com.sansec.crypto.digests.SHA256Digest;
import com.sansec.crypto.digests.SHA384Digest;
import com.sansec.crypto.digests.SHA512Digest;
import com.sansec.crypto.digests.SM3Digest;
import com.sansec.crypto.digests.SM3Digest1;
import com.sansec.crypto.encodings.SM2SignatureEncoding;
import com.sansec.crypto.engines.SM2SignEngine;
import com.sansec.jce.provider.JCESM2PrivateKey;
import com.sansec.jce.provider.JCESM2PublicKey;
import com.sansec.jce.provider.SM2Util;
import com.sansec.jce.provider.util.NullDigest;
import com.sansec.util.BigIntegers;
import com.sansec.util.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;

public class JDKSM2Signature
extends SignatureSpi {
    private static final byte[] ID = "1234567812345678".getBytes();
    private Digest digest;
    private Digest digestNoZValue;
    private Digest cfcaOldDigest = new SM3Digest1();
    private SM2SignatureEncoding cipher;
    private AlgorithmIdentifier algId;
    private static final boolean compatibleOld = true;

    protected JDKSM2Signature(Digest digest, SM2SignatureEncoding cipher) {
        this.digestNoZValue = new SM3Digest();
        this.digest = digest;
        this.cipher = cipher;
        this.algId = null;
    }

    protected JDKSM2Signature(DERObjectIdentifier objId, Digest digest, SM2SignatureEncoding cipher) {
        this.digestNoZValue = new SM3Digest();
        this.digest = digest;
        this.cipher = cipher;
        this.algId = new AlgorithmIdentifier(objId, DERNull.INSTANCE);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a ECPublicKey instance");
        }
        CipherParameters param = null;
        if (publicKey instanceof JCESM2PublicKey) {
            param = SM2Util.generatePublicKeyParameter((JCESM2PublicKey)publicKey);
        }
        this.cfcaOldDigest.reset();
        this.digestNoZValue.reset();
        this.digest.reset();
        if (this.digest instanceof SM3Digest) {
            BigInteger x = ((JCESM2PublicKey)publicKey).getW().getAffineX();
            BigInteger y = ((JCESM2PublicKey)publicKey).getW().getAffineY();
            ((SM3Digest)this.digest).addId(x, y, ID);
        }
        this.cipher.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Utils.printTime("cipher.init0");
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a ECPrivateKey instance");
        }
        Utils.printTime("cipher.init1");
        CipherParameters param = null;
        if (!(privateKey instanceof JCESM2PrivateKey)) {
            throw new InvalidKeyException("\u4e0d\u662f\u5408\u6cd5\u7684SM2\u79c1\u94a5");
        }
        param = SM2Util.generatePrivateKeyParameter((JCESM2PrivateKey)privateKey);
        Utils.printTime("cipher.init2");
        this.digest.reset();
        if (this.digest instanceof SM3Digest) {
            BigInteger x = ((JCESM2PrivateKey)privateKey).getX();
            BigInteger y = ((JCESM2PrivateKey)privateKey).getY();
            if (x == null || y == null) {
                throw new InvalidKeyException("\u6ca1\u6709\u5305\u542b\u516c\u94a5\u6570\u636e");
            }
            ((SM3Digest)this.digest).addId(x, y, ID);
        }
        this.cipher.init(true, param);
        Utils.printTime("cipher.init3");
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.cfcaOldDigest.update(b);
        this.digestNoZValue.update(b);
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.cfcaOldDigest.update(b, off, len);
        this.digestNoZValue.update(b, off, len);
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = hash;
            Utils.printTime("cipher.sign1");
            byte[] sigBytes = this.cipher.sign(bytes, 0, bytes.length);
            Utils.printTime("cipher.sign2");
            sigBytes = this.decoration(sigBytes);
            return sigBytes;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = null;
        byte[] hash1 = null;
        hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sigBytes = this.filter(sigBytes);
        }
        catch (IOException e1) {
            return false;
        }
        boolean flag = false;
        try {
            flag = this.cipher.verify(sigBytes, 0, sigBytes.length, hash, 0, hash.length);
        }
        catch (Exception ex) {
            flag = false;
        }
        if (this.digest instanceof SM3Digest) {
            if (!flag) {
                hash1 = new byte[this.digestNoZValue.getDigestSize()];
                this.digestNoZValue.doFinal(hash1, 0);
                try {
                    flag = this.cipher.verify(sigBytes, 0, sigBytes.length, hash1, 0, hash1.length);
                }
                catch (Exception ex) {
                    flag = false;
                }
            }
            if (!flag) {
                hash1 = new byte[this.cfcaOldDigest.getDigestSize()];
                this.cfcaOldDigest.doFinal(hash1, 0);
                try {
                    flag = this.cipher.verify(sigBytes, 0, sigBytes.length, hash1, 0, hash1.length);
                }
                catch (Exception ex) {
                    flag = false;
                }
            }
        }
        return flag;
    }

    private byte[] decoration(byte[] sigBytes) {
        if (sigBytes.length == 64) {
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            System.arraycopy(sigBytes, 0, r, 0, r.length);
            System.arraycopy(sigBytes, 32, s, 0, s.length);
            SM2SignStructure sig = new SM2SignStructure(new BigInteger(1, r), new BigInteger(1, s));
            return sig.getDEREncoded();
        }
        return sigBytes;
    }

    private byte[] filter(byte[] sigBytes) throws IOException {
        byte[] sig = sigBytes;
        if (sigBytes.length != 64) {
            byte[] r = null;
            byte[] s = null;
            ASN1InputStream ais = new ASN1InputStream(sigBytes);
            DERSequence seq = (DERSequence)ais.readObject();
            try {
                if (seq.size() != 2) {
                    throw new IllegalArgumentException("Bad sequence size: " + seq.size());
                }
                Enumeration e = seq.getObjects();
                r = BigIntegers.asUnsignedByteArray(DERInteger.getInstance(e.nextElement()).getPositiveValue());
                s = BigIntegers.asUnsignedByteArray(DERInteger.getInstance(e.nextElement()).getPositiveValue());
            }
            catch (Exception e) {
                SM2SignStructure sigSt = new SM2SignStructure(seq);
                r = BigIntegers.asUnsignedByteArray(sigSt.getR());
                s = BigIntegers.asUnsignedByteArray(sigSt.getS());
            }
            sig = new byte[64];
            System.arraycopy(r, 0, sig, 32 - r.length, r.length);
            System.arraycopy(s, 0, sig, 64 - s.length, s.length);
        }
        return sig;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
    }

    protected Object engineGetParameter(String param) {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class MD2WithSM2Encryption
    extends JDKSM2Signature {
        public MD2WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md2, new MD2Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class MD4WithSM2Encryption
    extends JDKSM2Signature {
        public MD4WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md4, new MD4Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class MD5WithSM2Encryption
    extends JDKSM2Signature {
        public MD5WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md5, new MD5Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class RIPEMD128WithSM2Encryption
    extends JDKSM2Signature {
        public RIPEMD128WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd128, new RIPEMD128Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class RIPEMD160WithSM2Encryption
    extends JDKSM2Signature {
        public RIPEMD160WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd160, new RIPEMD160Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class RIPEMD256WithSM2Encryption
    extends JDKSM2Signature {
        public RIPEMD256WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd256, new RIPEMD256Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SHA1WithSM2Encryption
    extends JDKSM2Signature {
        public SHA1WithSM2Encryption() {
            super(X509ObjectIdentifiers.id_SHA1, new SHA1Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SHA224WithSM2Encryption
    extends JDKSM2Signature {
        public SHA224WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha224, new SHA224Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SHA256WithSM2Encryption
    extends JDKSM2Signature {
        public SHA256WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha256, new SHA256Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SHA384WithSM2Encryption
    extends JDKSM2Signature {
        public SHA384WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha384, new SHA384Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SHA512WithSM2Encryption
    extends JDKSM2Signature {
        public SHA512WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha512, new SHA512Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class SM3WithSM2Encryption
    extends JDKSM2Signature {
        public SM3WithSM2Encryption() {
            super(null, new SM3Digest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }

    public static class noneSM2
    extends JDKSM2Signature {
        public noneSM2() {
            super(null, new NullDigest(), new SM2SignatureEncoding(new SM2SignEngine()));
        }
    }
}

