/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.SwRSAKeyParameters;
import com.sansec.crypto.params.SwRSAPrivateCrtKeyParameters;
import com.sansec.jce.provider.SwJCERSAPrivateCrtKey;
import com.sansec.jce.provider.SwJCERSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class RSAUtil {
    RSAUtil() {
    }

    static boolean isRsaOid(DERObjectIdentifier algOid) {
        return algOid.equals(PKCSObjectIdentifiers.rsaEncryption) || algOid.equals(X509ObjectIdentifiers.id_ea_rsa) || algOid.equals(PKCSObjectIdentifiers.id_RSASSA_PSS) || algOid.equals(PKCSObjectIdentifiers.id_RSAES_OAEP);
    }

    static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        if (key instanceof SwJCERSAPublicKey) {
            SwJCERSAPublicKey swKey = (SwJCERSAPublicKey)key;
            return new SwRSAKeyParameters(swKey.getKeyIndex(), false, key.getModulus(), key.getPublicExponent());
        }
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        RSAPrivateKey k;
        SwJCERSAPrivateCrtKey swKey;
        if (key instanceof SwJCERSAPrivateCrtKey && (swKey = (SwJCERSAPrivateCrtKey)key).getKeyIndex() > 0) {
            return new SwRSAPrivateCrtKeyParameters(swKey.getKeyIndex(), key.getModulus());
        }
        if (key instanceof RSAPrivateCrtKey) {
            k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        k = key;
        return new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent());
    }
}

