/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.device.SDSFactory;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.jce.provider.SwSecretKeySpec;
import com.sansec.util.Strings;
import com.sansec.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class SwJCEBlockCipher
extends CipherSpi {
    private int blockSize;
    private byte[] key = null;
    private int keyIndex = 0;
    private String padd = "PKCS5Padding";
    private String mode = "ECB";
    private int opmode;
    private byte[] iv = null;
    private AlgorithmParameters ivParameters = null;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private String algName;

    public SwJCEBlockCipher(String algName, int blockSize) {
        this.algName = algName;
        this.blockSize = blockSize;
        this.iv = new byte[blockSize];
    }

    public SwJCEBlockCipher(String algName, int blockSize, String padd, String mode) {
        this(algName, blockSize);
        this.padd = padd;
        this.mode = mode;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buf = new byte[this.engineGetOutputSize(inputLen)];
        try {
            int len = this.engineDoFinal(input, inputOffset, inputLen, buf, 0);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            return out;
        }
        catch (ShortBufferException e) {
            return null;
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.buf.write(input, inputOffset, inputLen);
        }
        if (this.buf.size() == 0) {
            throw new BadPaddingException("the cipher data size is 0");
        }
        byte[] out = this.process(true);
        System.arraycopy(out, 0, output, outputOffset, out.length);
        return out.length;
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected byte[] engineGetIV() {
        return this.iv;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.buf.size() + inputLen + this.blockSize;
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.ivParameters;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length * 8;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameters)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && params instanceof IvParameterSpec) {
            this.iv = ((IvParameterSpec)params).getIV();
        } else {
            Arrays.fill(this.iv, (byte)0);
        }
        if (this.iv.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV size is not blockSize");
        }
        this.buf.reset();
        if (key instanceof SwSecretKeySpec) {
            SwSecretKeySpec sw = (SwSecretKeySpec)key;
            if (sw.getKeyIndex() == 0) {
                this.key = key.getEncoded();
            } else {
                this.keyIndex = sw.getKeyIndex();
            }
        } else if (key.getEncoded().length % 8 == 0) {
            this.key = key.getEncoded();
        } else {
            throw new InvalidKeyException("key size invalid; key: " + new String(Hex.encode(key.getEncoded())));
        }
        if (opmode != 1 && opmode != 2) {
            throw new InvalidParameterException("unknown opmode " + opmode + " passed");
        }
        this.opmode = opmode;
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
                this.ivParameters = params;
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters get IvParameterSpec error:" + e.getMessage());
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeName = Strings.toUpperCase(mode);
        if (modeName.equals("ECB")) {
            this.mode = "ECB";
        } else if (modeName.equals("CBC")) {
            this.mode = "CBC";
        } else {
            throw new NoSuchAlgorithmException("can't support mode " + mode);
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equals("NOPADDING")) {
            this.padd = "NoPadding";
        } else if (paddingName.equals("PKCS5PADDING")) {
            this.padd = "PKCS5Padding";
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buf.write(input, inputOffset, inputLen);
        try {
            return this.process(false);
        }
        catch (BadPaddingException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.buf.write(input, inputOffset, inputLen);
        int bLen = 0;
        try {
            byte[] b = this.process(false);
            if (b != null) {
                bLen = b.length;
                System.arraycopy(b, 0, output, outputOffset, bLen);
            }
        }
        catch (BadPaddingException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return bLen;
    }

    private byte[] padding(byte[] input) throws IllegalBlockSizeException {
        int inputLen = input.length;
        byte[] outputData = null;
        if ("PKCS5Padding".equals(this.padd) && this.opmode == 1) {
            int padData = (inputLen / this.blockSize + 1) * this.blockSize - inputLen;
            outputData = new byte[inputLen + padData];
            int i = inputLen;
            while (i < outputData.length) {
                outputData[i] = (byte)padData;
                ++i;
            }
        } else {
            if (inputLen % this.blockSize != 0) {
                throw new IllegalBlockSizeException("\u6570\u636e\u957f\u5ea6[" + inputLen + "]\u5206\u7ec4\u957f\u5ea6[" + this.blockSize + "]");
            }
            outputData = new byte[inputLen];
        }
        System.arraycopy(input, 0, outputData, 0, inputLen);
        Arrays.fill(input, (byte)0);
        input = null;
        return outputData;
    }

    private byte[] Unpadding(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen = input.length;
        byte[] output = null;
        int outputLen = 0;
        if ("PKCS5Padding".equals(this.padd) && this.opmode == 2) {
            if (inputLen % this.blockSize != 0) {
                throw new IllegalBlockSizeException("\u6570\u636e\u957f\u5ea6[" + inputLen + "]\u5206\u7ec4\u957f\u5ea6[" + this.blockSize + "]");
            }
            byte padData = input[inputLen - 1];
            if (padData > this.blockSize || padData < 0) {
                throw new BadPaddingException("\u9519\u8bef\u7684\u8865\u4f4d, \u6700\u540e\u4e00\u4f4d[" + padData + "]\u5206\u7ec4\u957f\u5ea6[" + this.blockSize + "]");
            }
            outputLen = inputLen - padData;
        } else {
            outputLen = inputLen;
        }
        output = new byte[outputLen];
        System.arraycopy(input, 0, output, 0, outputLen);
        Arrays.fill(input, (byte)0);
        input = null;
        return output;
    }

    private int getAlgId() {
        int algId = 0;
        if ("ECB".equals(this.mode)) {
            if ("3DES".equals(this.algName)) {
                algId = 2049;
            } else if ("AES".equals(this.algName)) {
                algId = 1025;
            } else if ("SM1".equals(this.algName)) {
                algId = 257;
            } else if ("SM4".equals(this.algName)) {
                algId = 8193;
            } else if ("SSF33".equals(this.algName)) {
                algId = 513;
            }
        } else if ("3DES".equals(this.algName)) {
            algId = 2050;
        } else if ("AES".equals(this.algName)) {
            algId = 1026;
        } else if ("SM1".equals(this.algName)) {
            algId = 258;
        } else if ("SM4".equals(this.algName)) {
            algId = 8194;
        } else if ("SSF33".equals(this.algName)) {
            algId = 514;
        }
        return algId;
    }

    private byte[] process(boolean isFinal) throws BadPaddingException, IllegalBlockSizeException {
        byte[] input = this.buf.toByteArray();
        if (isFinal) {
            input = this.padding(input);
            this.buf.reset();
        } else {
            if (input.length < this.blockSize) {
                return null;
            }
            int tmpLen = input.length / this.blockSize * this.blockSize;
            byte[] tmp = new byte[tmpLen];
            System.arraycopy(input, 0, tmp, 0, tmpLen);
            this.buf.reset();
            this.buf.write(input, tmpLen, input.length - tmpLen);
            input = tmp;
        }
        ISDSCrypto crypto = null;
        try {
            crypto = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] out = null;
        int algId = this.getAlgId();
        if (this.opmode == 1) {
            try {
                out = this.keyIndex == 0 ? crypto.encrypt(algId, this.key, this.iv, input) : crypto.encrypt(algId, this.keyIndex, this.iv, input);
                System.arraycopy(out, out.length - this.iv.length, this.iv, 0, this.iv.length);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        if (this.opmode == 2) {
            try {
                out = this.keyIndex == 0 ? crypto.decrypt(algId, this.key, this.iv, input) : crypto.decrypt(algId, this.keyIndex, this.iv, input);
                System.arraycopy(input, input.length - this.iv.length, this.iv, 0, this.iv.length);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        if (isFinal) {
            out = this.Unpadding(out);
        }
        return out;
    }

    public static class AES
    extends SwJCEBlockCipher {
        public AES() {
            super("AES", 16);
        }
    }

    public static class AESCBC
    extends SwJCEBlockCipher {
        public AESCBC() {
            super("AES", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class DESede
    extends SwJCEBlockCipher {
        public DESede() {
            super("3DES", 8);
        }
    }

    public static class DESedeCBC
    extends SwJCEBlockCipher {
        public DESedeCBC() {
            super("3DES", 8, "PKCS5Padding", "CBC");
        }
    }

    public static class SM1
    extends SwJCEBlockCipher {
        public SM1() {
            super("SM1", 16);
        }
    }

    public static class SM1CBC
    extends SwJCEBlockCipher {
        public SM1CBC() {
            super("SM1", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SM4
    extends SwJCEBlockCipher {
        public SM4() {
            super("SM4", 16);
        }
    }

    public static class SM4CBC
    extends SwJCEBlockCipher {
        public SM4CBC() {
            super("SM4", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SSF33
    extends SwJCEBlockCipher {
        public SSF33() {
            super("SSF33", 16);
        }
    }

    public static class SSF33CBC
    extends SwJCEBlockCipher {
        public SSF33CBC() {
            super("SSF33", 16, "PKCS5Padding", "CBC");
        }
    }
}

