/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.jce.provider.SwSecretKeySpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class SwJCEKeyGenerator
extends KeyGeneratorSpi {
    protected String algName;
    protected int keysize;
    protected int defaultKeySize;
    protected Random rnd;
    protected boolean uninitialised = true;

    protected SwJCEKeyGenerator(String algName, int defaultKeySize) {
        this.algName = algName;
        this.keysize = this.defaultKeySize = defaultKeySize;
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    protected void engineInit(SecureRandom random) {
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    protected void engineInit(int keySize, SecureRandom random) {
        this.keysize = keySize;
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    protected SecretKey engineGenerateKey() {
        if (this.uninitialised) {
            try {
                this.rnd = SecureRandom.getInstance("RND", "SwxaJCE");
            }
            catch (Exception e) {
                this.rnd = new SecureRandom();
            }
            this.uninitialised = false;
        }
        byte[] key = new byte[this.defaultKeySize / 8];
        int keyIndex = this.keysize >>> 16;
        if (keyIndex == 0) {
            this.rnd.nextBytes(key);
        }
        return new SwSecretKeySpec(keyIndex, key, this.algName);
    }

    public static class AES
    extends SwJCEKeyGenerator {
        public AES() {
            super("AES", 128);
        }
    }

    public static class DESede
    extends SwJCEKeyGenerator {
        public DESede() {
            super("DESede", 128);
        }
    }

    public static class SM1
    extends SwJCEKeyGenerator {
        public SM1() {
            super("SM1", 128);
        }
    }

    public static class SM4
    extends SwJCEKeyGenerator {
        public SM4() {
            super("SM4", 128);
        }
    }

    public static class SSF33
    extends SwJCEKeyGenerator {
        public SSF33() {
            super("SSF33", 128);
        }
    }
}

