/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.DERNull;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.SwRSAPrivateCrtKeyParameters;
import com.sansec.jce.provider.JCERSAPrivateCrtKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;

public class SwJCERSAPrivateCrtKey
extends JCERSAPrivateCrtKey {
    private static final long serialVersionUID = 2883451835712788964L;
    private int keyIndex;

    public int getKeyIndex() {
        return this.keyIndex;
    }

    SwJCERSAPrivateCrtKey(RSAPrivateCrtKeyParameters key) {
        super(key);
        if (key instanceof SwRSAPrivateCrtKeyParameters) {
            this.keyIndex = ((SwRSAPrivateCrtKeyParameters)key).getKeyIndex();
        }
    }

    SwJCERSAPrivateCrtKey(RSAPrivateCrtKeySpec spec) {
        super(spec);
    }

    SwJCERSAPrivateCrtKey(RSAPrivateCrtKey key) {
        super(key);
    }

    SwJCERSAPrivateCrtKey(PrivateKeyInfo info) {
        super(info);
        BigInteger e = super.getPrivateExponent();
        int d = e.intValue();
        if (d > 0 && d < 50 && e.bitLength() < 32) {
            this.keyIndex = d;
        }
    }

    SwJCERSAPrivateCrtKey(RSAPrivateKeyStructure key) {
        super(key);
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPrivateKeyStructure(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()).getDERObject());
        return info.getDEREncoded();
    }

    public BigInteger getPublicExponent() {
        return super.getPublicExponent();
    }

    public BigInteger getPrimeP() {
        return super.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return super.getPrimeQ();
    }

    public BigInteger getPrimeExponentP() {
        return super.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return super.getPrimeExponentQ();
    }

    public BigInteger getCrtCoefficient() {
        return super.getCrtCoefficient();
    }

    public int hashCode() {
        if (this.keyIndex == 0) {
            return super.hashCode();
        }
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    public boolean equals(Object o) {
        if (this.keyIndex == 0) {
            return super.equals(o);
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwJCERSAPrivateCrtKey)) {
            return false;
        }
        SwJCERSAPrivateCrtKey key = (SwJCERSAPrivateCrtKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPublicExponent().equals(key.getPublicExponent()) && this.getKeyIndex() == key.getKeyIndex();
    }

    public String toString() {
        if (this.keyIndex == 0) {
            return super.toString();
        }
        return "\u5185\u90e8RSA\u79c1\u94a5[ " + this.keyIndex + " ]";
    }
}

