/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.SwRSAKeyParameters;
import com.sansec.jce.provider.JCERSAPublicKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

public class SwJCERSAPublicKey
extends JCERSAPublicKey {
    static final long serialVersionUID = -8145849727580266753L;
    private int keyIndex;

    public int getKeyIndex() {
        return this.keyIndex;
    }

    SwJCERSAPublicKey(RSAKeyParameters key) {
        super(key);
        if (key instanceof SwRSAKeyParameters) {
            this.keyIndex = ((SwRSAKeyParameters)key).getKeyIndex();
        }
    }

    SwJCERSAPublicKey(RSAPublicKeySpec spec) {
        super(spec);
    }

    SwJCERSAPublicKey(RSAPublicKey key) {
        super(key);
    }

    SwJCERSAPublicKey(SubjectPublicKeyInfo info) {
        super(info);
    }

    public BigInteger getModulus() {
        return super.getModulus();
    }

    public BigInteger getPublicExponent() {
        return super.getPublicExponent();
    }

    public String getAlgorithm() {
        return super.getAlgorithm();
    }

    public String getFormat() {
        return super.getFormat();
    }

    public byte[] getEncoded() {
        return super.getEncoded();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this.keyIndex == 0) {
            return super.equals(o);
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwJCERSAPublicKey)) {
            return false;
        }
        SwJCERSAPublicKey key = (SwJCERSAPublicKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPublicExponent().equals(key.getPublicExponent()) && this.getKeyIndex() == key.getKeyIndex();
    }

    public String toString() {
        if (this.keyIndex == 0) {
            return super.toString();
        }
        return "\u5185\u90e8RSA\u516c\u94a5[ " + this.keyIndex + " ]";
    }
}

