/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.symmetric;

import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.engines.SEEDEngine;
import com.sansec.crypto.engines.SEEDWrapEngine;
import com.sansec.crypto.modes.CBCBlockCipher;
import com.sansec.jce.provider.JCEBlockCipher;
import com.sansec.jce.provider.JCEKeyGenerator;
import com.sansec.jce.provider.JDKAlgorithmParameterGenerator;
import com.sansec.jce.provider.JDKAlgorithmParameters;
import com.sansec.jce.provider.WrapCipherSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SEED {
    private SEED() {
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("SEED", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new SEEDEngine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new SEEDWrapEngine());
        }
    }
}

