/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.SimpleTest;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESSICTest
extends SimpleTest {
    private byte[][] keys = new byte[][]{Hex.decode("2b7e151628aed2a6abf7158809cf4f3c"), Hex.decode("8e73b0f7da0e6452c810f32b809079e562f8ead2522c6b7b"), Hex.decode("603deb1015ca71be2b73aef0857d77811f352c073b6108d72d9810a30914dff4")};
    private byte[][] plain = new byte[][]{Hex.decode("6bc1bee22e409f96e93d7e117393172a"), Hex.decode("ae2d8a571e03ac9c9eb76fac45af8e51"), Hex.decode("30c81c46a35ce411e5fbc1191a0a52ef"), Hex.decode("f69f2445df4f9b17ad2b417be66c3710")};
    private byte[][][] cipher = new byte[][][]{new byte[][]{Hex.decode("874d6191b620e3261bef6864990db6ce"), Hex.decode("9806f66b7970fdff8617187bb9fffdff"), Hex.decode("5ae4df3edbd5d35e5b4f09020db03eab"), Hex.decode("1e031dda2fbe03d1792170a0f3009cee")}, new byte[][]{Hex.decode("1abc932417521ca24f2b0459fe7e6e0b"), Hex.decode("090339ec0aa6faefd5ccc2c6f4ce8e94"), Hex.decode("1e36b26bd1ebc670d1bd1d665620abf7"), Hex.decode("4f78a7f6d29809585a97daec58c6b050")}, new byte[][]{Hex.decode("601ec313775789a5b7a7f504bbf3d228"), Hex.decode("f443e3ca4d62b59aca84e990cacaf5c5"), Hex.decode("2b0930daa23de94ce87017ba2d84988d"), Hex.decode("dfc9c58db67aada613c2dd08457941a6")}};

    public String getName() {
        return "AESSIC";
    }

    public void performTest() throws Exception {
        Cipher c = Cipher.getInstance("AES/SIC/NoPadding", "BC");
        int i = 0;
        while (i != this.keys.length) {
            byte[] crypt;
            SecretKeySpec sk = new SecretKeySpec(this.keys[i], "AES");
            c.init(1, (Key)sk, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF")));
            int j = 0;
            while (j != this.plain.length) {
                crypt = c.update(this.plain[j]);
                if (!this.areEqual(crypt, this.cipher[i][j])) {
                    this.fail("AESSIC encrypt failed: key " + i + " block " + j);
                }
                ++j;
            }
            c.init(2, (Key)sk, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF")));
            j = 0;
            while (j != this.plain.length) {
                crypt = c.update(this.cipher[i][j]);
                if (!this.areEqual(crypt, this.plain[j])) {
                    this.fail("AESSIC decrypt failed: key " + i + " block " + j);
                }
                ++j;
            }
            ++i;
        }
        c = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        SecretKeySpec sk = new SecretKeySpec(Hex.decode("2B7E151628AED2A6ABF7158809CF4F3C"), "AES");
        c.init(1, (Key)sk, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
        byte[] crypt = c.doFinal(Hex.decode("00000000000000000000000000000000"));
        if (!this.areEqual(crypt, Hex.decode("D23513162B02D0F72A43A2FE4A5F97AB"))) {
            this.fail("AESSIC failed test 2");
        }
        c = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        sk = new SecretKeySpec(Hex.decode("2B7E151628AED2A6ABF7158809CF4F3C"), "AES");
        c.init(1, (Key)sk, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
        crypt = c.doFinal(Hex.decode("12345678"));
        c.init(2, (Key)sk, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
        crypt = c.doFinal(crypt);
        if (!this.areEqual(crypt, Hex.decode("12345678"))) {
            this.fail("AESSIC failed partial test");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        AESSICTest.runTest(new AESSICTest());
    }
}

