/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.ntt.NTTObjectIdentifiers;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.provider.test.BaseBlockCipherTest;
import com.sansec.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public class CamelliaTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "0123456789abcdeffedcba9876543210", "0123456789abcdeffedcba9876543210", "67673138549669730857065648eabe43", "192", "0123456789abcdeffedcba98765432100011223344556677", "0123456789abcdeffedcba9876543210", "b4993401b3e996f84ee5cee7d79b09b9", "256", "0123456789abcdeffedcba987654321000112233445566778899aabbccddeeff", "0123456789abcdeffedcba9876543210", "9acc237dff16d76c20ef7c919e3a7509"};

    public CamelliaTest() {
        super("Camellia");
    }

    public void test(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "Camellia");
        Cipher in = Cipher.getInstance("Camellia/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("Camellia/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("Camellia failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("Camellia failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("Camellia failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("Camellia failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("Camellia failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("Camellia failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    public void performTest() throws Exception {
        int i = 0;
        while (i != cipherTests.length) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
            i += 4;
        }
        byte[] kek1 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] in1 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] out1 = Hex.decode("635d6ac46eedebd3a7f4a06421a4cbd1746b24795ba2f708");
        this.wrapTest(1, "CamelliaWrap", kek1, in1, out1);
        String[] oids = new String[]{NTTObjectIdentifiers.id_camellia128_cbc.getId(), NTTObjectIdentifiers.id_camellia192_cbc.getId(), NTTObjectIdentifiers.id_camellia256_cbc.getId()};
        String[] names = new String[]{"Camellia/CBC/PKCS7Padding", "Camellia/CBC/PKCS7Padding", "Camellia/CBC/PKCS7Padding"};
        this.oidTest(oids, names, 1);
        String[] wrapOids = new String[]{NTTObjectIdentifiers.id_camellia128_wrap.getId(), NTTObjectIdentifiers.id_camellia192_wrap.getId(), NTTObjectIdentifiers.id_camellia256_wrap.getId()};
        this.wrapOidTest(wrapOids, "CamelliaWrap");
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        CamelliaTest.runTest(new CamelliaTest());
    }
}

