/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.provider.test.CertPathTest;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CertStoreTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.basicTest();
        this.orderTest();
    }

    private void basicTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        list.add(rootCrl);
        list.add(interCrl);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        X509CertSelector targetConstraints = new X509CertSelector();
        targetConstraints.setSubject(rootCert.getSubjectX500Principal().getName());
        Collection<? extends Certificate> certs = store.getCertificates(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by subjectDN");
        }
        targetConstraints = new X509CertSelector();
        targetConstraints.setSubject(rootCert.getSubjectX500Principal().getEncoded());
        certs = store.getCertificates(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by encoded subjectDN");
        }
        targetConstraints = new X509CertSelector();
        targetConstraints.setSubjectPublicKey(rootCert.getPublicKey().getEncoded());
        certs = store.getCertificates(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by encoded public key");
        }
        targetConstraints = new X509CertSelector();
        targetConstraints.setIssuer(rootCert.getSubjectX500Principal().getEncoded());
        certs = store.getCertificates(targetConstraints);
        if (certs.size() != 2) {
            this.fail("did not found 2 certs");
        }
        if (!certs.contains(rootCert)) {
            this.fail("rootCert not found");
        }
        if (!certs.contains(interCert)) {
            this.fail("interCert not found");
        }
        X509CRLSelector targetConstraintsCRL = new X509CRLSelector();
        targetConstraintsCRL.addIssuerName(rootCrl.getIssuerX500Principal().getEncoded());
        Collection<? extends CRL> crls = store.getCRLs(targetConstraintsCRL);
        if (crls.size() != 1 || !crls.contains(rootCrl)) {
            this.fail("rootCrl not found");
        }
    }

    private void orderTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        Iterator<? extends Certificate> certs = store.getCertificates(null).iterator();
        if (!((Object)certs.next()).equals(rootCert)) {
            this.fail("root ordering wrong");
        }
        if (!((Object)certs.next()).equals(interCert)) {
            this.fail("mid ordering wrong");
        }
        if (!((Object)certs.next()).equals(finalCert)) {
            this.fail("final ordering wrong");
        }
        list = new ArrayList();
        list.add(finalCert);
        list.add(interCert);
        list.add(rootCert);
        ccsp = new CollectionCertStoreParameters(list);
        store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        certs = store.getCertificates(null).iterator();
        if (!((Object)certs.next()).equals(finalCert)) {
            this.fail("reverse final ordering wrong");
        }
        if (!((Object)certs.next()).equals(interCert)) {
            this.fail("reverse mid ordering wrong");
        }
        if (!((Object)certs.next()).equals(rootCert)) {
            this.fail("reverse root ordering wrong");
        }
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        list = new ArrayList();
        list.add(finalCert);
        list.add(rootCrl);
        list.add(interCrl);
        ccsp = new CollectionCertStoreParameters(list);
        store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        Iterator<? extends CRL> crls = store.getCRLs(null).iterator();
        if (!crls.next().equals(rootCrl)) {
            this.fail("root crl ordering wrong");
        }
        if (!crls.next().equals(interCrl)) {
            this.fail("mid crl ordering wrong");
        }
        list = new ArrayList();
        list.add(finalCert);
        list.add(interCrl);
        list.add(rootCrl);
        ccsp = new CollectionCertStoreParameters(list);
        store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        crls = store.getCRLs(null).iterator();
        if (!crls.next().equals(interCrl)) {
            this.fail("reverse mid crl ordering wrong");
        }
        if (!crls.next().equals(rootCrl)) {
            this.fail("reverse root crl ordering wrong");
        }
    }

    public String getName() {
        return "CertStore";
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        CertStoreTest.runTest(new CertStoreTest());
    }
}

