/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.jce.X509Principal;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.Arrays;
import com.sansec.util.test.SimpleTest;
import com.sansec.x509.X509V3CertificateGenerator;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class CertUniqueIDTest
extends SimpleTest {
    public String getName() {
        return "CertUniqueID";
    }

    public void performTest() throws Exception {
        this.checkCreation1();
    }

    public void checkCreation1() throws Exception {
        boolean[] issuerUniqueId;
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeySpec privKeySpec = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
        KeyFactory fact = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privKey = fact.generatePrivate(privKeySpec);
        PublicKey pubKey = fact.generatePublic(pubKeySpec);
        Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
        attrs.put(X509Principal.C, "AU");
        attrs.put(X509Principal.O, "The Legion of the Bouncy Castle");
        attrs.put(X509Principal.L, "Melbourne");
        attrs.put(X509Principal.ST, "Victoria");
        attrs.put(X509Principal.E, "feedback-crypto@bouncycastle.org");
        Vector<DERObjectIdentifier> ord = new Vector<DERObjectIdentifier>();
        Vector<String> values = new Vector<String>();
        ord.addElement(X509Principal.C);
        ord.addElement(X509Principal.O);
        ord.addElement(X509Principal.L);
        ord.addElement(X509Principal.ST);
        ord.addElement(X509Principal.E);
        values.addElement("AU");
        values.addElement("The Legion of the Bouncy Castle");
        values.addElement("Melbourne");
        values.addElement("Victoria");
        values.addElement("feedback-crypto@bouncycastle.org");
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(new X509Principal(attrs));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal(attrs));
        certGen.setPublicKey(pubKey);
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        X509Certificate cert = certGen.generate(privKey);
        cert.checkValidity(new Date());
        cert.verify(pubKey);
        Set<String> dummySet = cert.getNonCriticalExtensionOIDs();
        if (dummySet != null) {
            this.fail("non-critical oid set should be null");
        }
        if ((dummySet = cert.getCriticalExtensionOIDs()) != null) {
            this.fail("critical oid set should be null");
        }
        certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(new X509Principal(attrs));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal(attrs));
        certGen.setPublicKey(pubKey);
        certGen.setSignatureAlgorithm("MD5WithRSAEncryption");
        boolean[] blArray = new boolean[11];
        blArray[0] = true;
        blArray[4] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[10] = true;
        boolean[] subjectUniqID = blArray;
        certGen.setSubjectUniqueID(subjectUniqID);
        boolean[] blArray2 = new boolean[15];
        blArray2[2] = true;
        blArray2[4] = true;
        blArray2[8] = true;
        blArray2[11] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        boolean[] issuerUniqID = blArray2;
        certGen.setIssuerUniqueID(issuerUniqID);
        cert = certGen.generate(privKey);
        cert.checkValidity(new Date());
        cert.verify(pubKey);
        boolean[] subjectUniqueId = cert.getSubjectUniqueID();
        if (!Arrays.areEqual(subjectUniqID, subjectUniqueId)) {
            this.fail("Subject unique id is not correct, original: " + this.arrayToString(subjectUniqID) + ", from cert: " + this.arrayToString(subjectUniqueId));
        }
        if (!Arrays.areEqual(issuerUniqID, issuerUniqueId = cert.getIssuerUniqueID())) {
            this.fail("Issuer unique id is not correct, original: " + this.arrayToString(issuerUniqID) + ", from cert: " + this.arrayToString(subjectUniqueId));
        }
    }

    private String arrayToString(boolean[] array) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i != array.length) {
            b.append(array[i] ? "1" : "0");
            ++i;
        }
        return b.toString();
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        CertUniqueIDTest.runTest(new CertUniqueIDTest());
    }
}

