/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherStreamTest
extends SimpleTest {
    private static byte[] RK = Hex.decode("0123456789ABCDEF");
    private static byte[] RIN = Hex.decode("4e6f772069732074");
    private static byte[] ROUT = Hex.decode("3afbb5c77938280d");
    private static byte[] SIN = Hex.decode("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] SK = Hex.decode("80000000000000000000000000000000");
    private static final byte[] SIV = Hex.decode("0000000000000000");
    private static final byte[] SOUT = Hex.decode("4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA");
    private static final byte[] HCIN = new byte[64];
    private static final byte[] HCIV = new byte[32];
    private static final byte[] HCK256A = new byte[32];
    private static final byte[] HC256A = Hex.decode("5B078985D8F6F30D42C5C02FA6B6795153F06534801F89F24E74248B720B4818CD9227ECEBCF4DBF8DBF6977E4AE14FAE8504C7BC8A9F3EA6C0106F5327E6981");
    private static final byte[] HCK128A = new byte[16];
    private static final byte[] HC128A = Hex.decode("82001573A003FD3B7FD72FFB0EAF63AAC62F12DEB629DCA72785A66268EC758B1EDB36900560898178E0AD009ABF1F491330DC1C246E3D6CB264F6900271D59C");
    private static final byte[] GRAIN_V1 = Hex.decode("0123456789abcdef1234");
    private static final byte[] GRAIN_V1_IV = Hex.decode("0123456789abcdef");
    private static final byte[] GRAIN_V1_IN = new byte[10];
    private static final byte[] GRAIN_V1_OUT = Hex.decode("7f362bd3f7abae203664");
    private static final byte[] GRAIN_128 = Hex.decode("0123456789abcdef123456789abcdef0");
    private static final byte[] GRAIN_128_IV = Hex.decode("0123456789abcdef12345678");
    private static final byte[] GRAIN_128_IN = new byte[16];
    private static final byte[] GRAIN_128_OUT = Hex.decode("afb5babfa8de896b4b9c6acaf7c4fbfd");

    private void runTest(String name) throws Exception {
        int c;
        String lCode = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        KeyGenerator kGen = name.indexOf(47) < 0 ? KeyGenerator.getInstance(name, "BC") : KeyGenerator.getInstance(name.substring(0, name.indexOf(47)), "BC");
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        SecretKey key = kGen.generateKey();
        ByteArrayInputStream bIn = new ByteArrayInputStream(lCode.getBytes());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        in.init(1, key);
        if (in.getIV() != null) {
            out.init(2, (Key)key, new IvParameterSpec(in.getIV()));
        } else {
            out.init(2, key);
        }
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        while ((c = cIn.read()) >= 0) {
            cOut.write(c);
        }
        cIn.close();
        cOut.flush();
        cOut.close();
        String res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed - decrypted data doesn't match.");
        }
    }

    private void testAlgorithm(String name, byte[] keyBytes, byte[] iv, byte[] plainText, byte[] cipherText) throws Exception {
        byte[] dec;
        SecretKeySpec key = new SecretKeySpec(keyBytes, name);
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        if (iv != null) {
            in.init(1, (Key)key, new IvParameterSpec(iv));
            out.init(2, (Key)key, new IvParameterSpec(iv));
        } else {
            in.init(1, key);
            out.init(2, key);
        }
        byte[] enc = in.doFinal(plainText);
        if (!this.areEqual(enc, cipherText)) {
            this.fail(String.valueOf(name) + ": cipher text doesn't match");
        }
        if (!this.areEqual(dec = out.doFinal(enc), plainText)) {
            this.fail(String.valueOf(name) + ": plain text doesn't match");
        }
    }

    private void testException(String name) {
        try {
            Key k;
            Cipher c2;
            byte[] key128 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] key256 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] keyBytes = name.equals("HC256") ? key256 : key128;
            SecretKeySpec cipherKey = new SecretKeySpec(keyBytes, name);
            Cipher ecipher = Cipher.getInstance(name, "BC");
            ecipher.init(1, cipherKey);
            byte[] cipherText = new byte[]{};
            try {
                ecipher.update(new byte[20], 0, 20, cipherText);
                this.fail("failed exception test - no ShortBufferException thrown");
            }
            catch (ShortBufferException shortBufferException) {
                // empty catch block
            }
            try {
                c2 = Cipher.getInstance(name, "BC");
                k = new PublicKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c2.init(1, k);
                this.fail("failed exception test - no InvalidKeyException thrown for public key");
            }
            catch (InvalidKeyException c2) {
                // empty catch block
            }
            try {
                c2 = Cipher.getInstance(name, "BC");
                k = new PrivateKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c2.init(2, k);
                this.fail("failed exception test - no InvalidKeyException thrown for private key");
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        catch (Exception e) {
            this.fail("unexpected exception.", e);
        }
    }

    public void performTest() throws Exception {
        this.runTest("RC4");
        this.testException("RC4");
        this.testAlgorithm("RC4", RK, null, RIN, ROUT);
        this.runTest("Salsa20");
        this.testException("Salsa20");
        this.testAlgorithm("Salsa20", SK, SIV, SIN, SOUT);
        this.runTest("HC128");
        this.testException("HC128");
        this.testAlgorithm("HC128", HCK128A, HCIV, HCIN, HC128A);
        this.runTest("HC256");
        this.testException("HC256");
        this.testAlgorithm("HC256", HCK256A, HCIV, HCIN, HC256A);
        this.runTest("VMPC");
        this.testException("VMPC");
        this.runTest("VMPC-KSA3");
        this.testException("VMPC-KSA3");
        this.testAlgorithm("Grainv1", GRAIN_V1, GRAIN_V1_IV, GRAIN_V1_IN, GRAIN_V1_OUT);
        this.testAlgorithm("Grain128", GRAIN_128, GRAIN_128_IV, GRAIN_128_IN, GRAIN_128_OUT);
        this.runTest("DES/ECB/PKCS7Padding");
        this.runTest("DES/CFB8/NoPadding");
    }

    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        CipherStreamTest.runTest(new CipherStreamTest());
    }
}

