/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DESedeTest
extends SimpleTest {
    static String[] cipherTests1 = new String[]{"112", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "128", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "168", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89", "192", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89"};
    static byte[] input1 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
    static byte[] input2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c");
    static RC2ParameterSpec rc2Spec = new RC2ParameterSpec(128, Hex.decode("0123456789abcdef"));
    static RC5ParameterSpec rc5Spec = new RC5ParameterSpec(16, 16, 32, Hex.decode("0123456789abcdef"));

    public String getName() {
        return "DESEDE";
    }

    private boolean equalArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equalArray(byte[] a, byte[] b, int length) {
        if (a.length < length) {
            return false;
        }
        if (b.length < length) {
            return false;
        }
        int i = 0;
        while (i != length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void wrapTest(int id, byte[] kek, byte[] iv, byte[] in, byte[] out) {
        try {
            Cipher wrapper = Cipher.getInstance("DESedeWrap", "BC");
            wrapper.init(3, (Key)new SecretKeySpec(kek, "DESEDE"), new IvParameterSpec(iv));
            try {
                byte[] cText = wrapper.wrap(new SecretKeySpec(in, "DESEDE"));
                if (!this.equalArray(cText, out)) {
                    this.fail("failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
                }
            }
            catch (Exception e) {
                this.fail("failed wrap test exception " + e.toString());
            }
            wrapper.init(4, new SecretKeySpec(kek, "DESEDE"));
            try {
                Key pText = wrapper.unwrap(out, "DESede", 3);
                if (!this.equalArray(pText.getEncoded(), in)) {
                    this.fail("failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText.getEncoded())));
                }
            }
            catch (Exception e) {
                this.fail("failed unwrap test exception " + e.toString());
            }
        }
        catch (Exception ex) {
            this.fail("failed exception " + ex.toString());
        }
    }

    public void test(int strength, byte[] input, byte[] output) {
        SecretKey key = null;
        Cipher in = null;
        Cipher out = null;
        FixedSecureRandom rand = new FixedSecureRandom();
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("DESEDE", "BC");
            keyGen.init(strength, (SecureRandom)rand);
            key = keyGen.generateKey();
            in = Cipher.getInstance("DESEDE/ECB/PKCS7Padding", "BC");
            out = Cipher.getInstance("DESEDE/ECB/PKCS7Padding", "BC");
            out.init(1, (Key)key, (SecureRandom)rand);
        }
        catch (Exception e) {
            this.fail("DESEDE failed initialisation - " + e.toString());
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("DESEDE failed initialisation - " + e.toString());
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("DESEDE failed encryption - " + e.toString());
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.equalArray(bytes, output)) {
            this.fail("DESEDE failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("DESEDE failed encryption - " + e.toString());
        }
        if (!this.equalArray(bytes, input)) {
            this.fail("DESEDE failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede", "BC");
            DESedeKeySpec keySpec = (DESedeKeySpec)keyFactory.getKeySpec(key, DESedeKeySpec.class);
            if (!this.equalArray(key.getEncoded(), keySpec.getKey(), 16)) {
                this.fail("DESEDE KeySpec does not match key.");
            }
        }
        catch (Exception e) {
            this.fail("DESEDE failed keyspec - " + e.toString());
        }
    }

    public void performTest() {
        int i = 0;
        while (i != cipherTests1.length) {
            this.test(Integer.parseInt(cipherTests1[i]), input1, Hex.decode(cipherTests1[i + 1]));
            i += 2;
        }
        byte[] kek1 = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
        byte[] iv1 = Hex.decode("5dd4cbfc96f5453b");
        byte[] in1 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98");
        byte[] out1 = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4");
        this.wrapTest(1, kek1, iv1, in1, out1);
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        DESedeTest.runTest(new DESedeTest());
    }

    private class FixedSecureRandom
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private FixedSecureRandom() {
        }

        public void nextBytes(byte[] bytes) {
            int offset = 0;
            while (offset + this.seed.length < bytes.length) {
                System.arraycopy(this.seed, 0, bytes, offset, this.seed.length);
                offset += this.seed.length;
            }
            System.arraycopy(this.seed, 0, bytes, offset, bytes.length - offset);
        }
    }
}

