/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.sec.SECObjectIdentifiers;
import com.sansec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.jce.ECKeyUtil;
import com.sansec.jce.ECPointUtil;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.BigIntegers;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.FixedSecureRandom;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class ECDSA5Test
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});

    private void decodeTest() {
        EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger("6277101735386680763835789423207666416083908700390324961279")), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECPoint p = ECPointUtil.decodePoint(curve, Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012"));
        if (!p.getAffineX().equals(new BigInteger("188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012", 16))) {
            this.fail("x uncompressed incorrectly");
        }
        if (!p.getAffineY().equals(new BigInteger("7192b95ffc8da78631011ed6b24cdd573f977a11e794811", 16))) {
            this.fail("y uncompressed incorrectly");
        }
    }

    private void testECDSA239bitPrime() throws Exception {
        BigInteger[] sig;
        BigInteger r = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger s = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        byte[] kData = BigIntegers.asUnsignedByteArray(new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655"));
        FixedSecureRandom k = new FixedSecureRandom(kData);
        EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec spec = new ECParameterSpec(curve, ECPointUtil.decodePoint(curve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        ECPrivateKeySpec priKey = new ECPrivateKeySpec(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), spec);
        ECPublicKeySpec pubKey = new ECPublicKeySpec(ECPointUtil.decodePoint(curve, Hex.decode("025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), spec);
        Signature sgr = Signature.getInstance("ECDSA", "BC");
        KeyFactory f = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey sKey = f.generatePrivate(priKey);
        PublicKey vKey = f.generatePublic(pubKey);
        sgr.initSign(sKey, k);
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!r.equals((sig = this.derDecode(sigBytes))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + r + System.getProperty("line.separator") + " got      : " + sig[0]);
        }
        if (!s.equals(sig[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + s + System.getProperty("line.separator") + " got      : " + sig[1]);
        }
    }

    private void testECDSA239bitBinary() throws Exception {
        BigInteger[] sig;
        BigInteger r = new BigInteger("21596333210419611985018340039034612628818151486841789642455876922391552");
        BigInteger s = new BigInteger("197030374000731686738334997654997227052849804072198819102649413465737174");
        byte[] kData = BigIntegers.asUnsignedByteArray(new BigInteger("171278725565216523967285789236956265265265235675811949404040041670216363"));
        FixedSecureRandom k = new FixedSecureRandom(kData);
        EllipticCurve curve = new EllipticCurve(new ECFieldF2m(239, new int[]{36}), new BigInteger("32010857077C5431123A46B808906756F543423E8D27877578125778AC76", 16), new BigInteger("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16", 16));
        ECParameterSpec params = new ECParameterSpec(curve, ECPointUtil.decodePoint(curve, Hex.decode("0457927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305")), new BigInteger("220855883097298041197912187592864814557886993776713230936715041207411783"), 4);
        ECPrivateKeySpec priKeySpec = new ECPrivateKeySpec(new BigInteger("145642755521911534651321230007534120304391871461646461466464667494947990"), params);
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ECPointUtil.decodePoint(curve, Hex.decode("045894609CCECF9A92533F630DE713A958E96C97CCB8F5ABB5A688A238DEED6DC2D9D0C94EBFB7D526BA6A61764175B99CB6011E2047F9F067293F57F5")), params);
        Signature sgr = Signature.getInstance("ECDSA", "BC");
        KeyFactory f = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey sKey = f.generatePrivate(priKeySpec);
        PublicKey vKey = f.generatePublic(pubKeySpec);
        byte[] message = new byte[]{97, 98, 99};
        sgr.initSign(sKey, k);
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!r.equals((sig = this.derDecode(sigBytes))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + r + System.getProperty("line.separator") + " got      : " + sig[0]);
        }
        if (!s.equals(sig[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + s + System.getProperty("line.separator") + " got      : " + sig[1]);
        }
    }

    private void testGeneration() throws Exception {
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 5;
        byArray[5] = 6;
        byArray[6] = 7;
        byArray[7] = 8;
        byArray[8] = 9;
        byte[] data = byArray;
        Signature s = Signature.getInstance("ECDSA", "BC");
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
        EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec ecSpec = new ECParameterSpec(curve, ECPointUtil.decodePoint(curve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        g.initialize(ecSpec, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        PrivateKey sKey = p.getPrivate();
        PublicKey vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("ECDSA", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("ECDSA verification failed");
        }
        this.testKeyFactory((ECPublicKey)vKey, (ECPrivateKey)sKey);
        this.testSerialise((ECPublicKey)vKey, (ECPrivateKey)sKey);
    }

    private void testSerialise(ECPublicKey ecPublicKey, ECPrivateKey ecPrivateKey) throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(ecPublicKey);
        oOut.writeObject(ecPrivateKey);
        oOut.close();
        ObjectInputStream oIn = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));
        PublicKey pubKey = (PublicKey)oIn.readObject();
        PrivateKey privKey = (PrivateKey)oIn.readObject();
        if (!ecPublicKey.equals(pubKey)) {
            this.fail("public key serialisation check failed");
        }
        if (!ecPrivateKey.equals(privKey)) {
            this.fail("private key serialisation check failed");
        }
    }

    private void testKeyFactory(ECPublicKey pub, ECPrivateKey priv) throws Exception {
        KeyFactory ecFact = KeyFactory.getInstance("ECDSA");
        ECPublicKeySpec pubSpec = ecFact.getKeySpec(pub, ECPublicKeySpec.class);
        ECPrivateKeySpec privSpec = ecFact.getKeySpec(priv, ECPrivateKeySpec.class);
        if (!pubSpec.getW().equals(pub.getW()) || !pubSpec.getParams().getCurve().equals(pub.getParams().getCurve())) {
            this.fail("pubSpec not correct");
        }
        if (!privSpec.getS().equals(priv.getS()) || !privSpec.getParams().getCurve().equals(priv.getParams().getCurve())) {
            this.fail("privSpec not correct");
        }
        ECPublicKey pubKey = (ECPublicKey)ecFact.translateKey(pub);
        ECPrivateKey privKey = (ECPrivateKey)ecFact.translateKey(priv);
        if (!pubKey.getW().equals(pub.getW()) || !pubKey.getParams().getCurve().equals(pub.getParams().getCurve())) {
            this.fail("pubKey not correct");
        }
        if (!privKey.getS().equals(priv.getS()) || !privKey.getParams().getCurve().equals(priv.getParams().getCurve())) {
            this.fail("privKey not correct");
        }
    }

    private void testKeyConversion() throws Exception {
        PrivateKey privKey;
        PrivateKeyInfo privInfo;
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        kpGen.initialize(new ECGenParameterSpec("prime192v1"));
        KeyPair pair = kpGen.generateKeyPair();
        PublicKey pubKey = ECKeyUtil.publicToExplicitParameters(pair.getPublic(), "BC");
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(pubKey.getEncoded()));
        X962Parameters params = X962Parameters.getInstance(info.getAlgorithmId().getParameters());
        if (params.isNamedCurve() || params.isImplicitlyCA()) {
            this.fail("public key conversion to explicit failed");
        }
        if (!((ECPublicKey)pair.getPublic()).getW().equals(((ECPublicKey)pubKey).getW())) {
            this.fail("public key conversion check failed");
        }
        if ((params = X962Parameters.getInstance((privInfo = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray((privKey = ECKeyUtil.privateToExplicitParameters(pair.getPrivate(), "BC")).getEncoded()))).getAlgorithmId().getParameters())).isNamedCurve() || params.isImplicitlyCA()) {
            this.fail("private key conversion to explicit failed");
        }
        if (!((ECPrivateKey)pair.getPrivate()).getS().equals(((ECPrivateKey)privKey).getS())) {
            this.fail("private key conversion check failed");
        }
    }

    private void testKeyPairGenerationWithOIDs() throws Exception {
        block5: {
            KeyPairGenerator kpGen;
            block4: {
                kpGen = KeyPairGenerator.getInstance("ECDSA", "BC");
                kpGen.initialize(new ECGenParameterSpec(X9ObjectIdentifiers.prime192v1.getId()));
                kpGen.initialize(new ECGenParameterSpec(TeleTrusTObjectIdentifiers.brainpoolP160r1.getId()));
                kpGen.initialize(new ECGenParameterSpec(SECObjectIdentifiers.secp128r1.getId()));
                try {
                    kpGen.initialize(new ECGenParameterSpec("1.1"));
                    this.fail("non-existant curve OID failed");
                }
                catch (InvalidAlgorithmParameterException e) {
                    if ("unknown curve OID: 1.1".equals(e.getMessage())) break block4;
                    this.fail("OID message check failed");
                }
            }
            try {
                kpGen.initialize(new ECGenParameterSpec("flibble"));
                this.fail("non-existant curve name failed");
            }
            catch (InvalidAlgorithmParameterException e) {
                if ("unknown curve name: flibble".equals(e.getMessage())) break block5;
                this.fail("name message check failed");
            }
        }
    }

    protected BigInteger[] derDecode(byte[] encoding) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1Sequence s = (ASN1Sequence)aIn.readObject();
        BigInteger[] sig = new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
        return sig;
    }

    public String getName() {
        return "ECDSA5";
    }

    public void performTest() throws Exception {
        this.testKeyConversion();
        this.decodeTest();
        this.testECDSA239bitPrime();
        this.testECDSA239bitBinary();
        this.testGeneration();
        this.testKeyPairGenerationWithOIDs();
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        ECDSA5Test.runTest(new ECDSA5Test());
    }
}

