/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.jce.X509Principal;
import com.sansec.jce.provider.JCEECPrivateKey;
import com.sansec.jce.provider.JCEECPublicKey;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.spec.ECParameterSpec;
import com.sansec.math.ec.ECCurve;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.SimpleTest;
import com.sansec.x509.X509V3CertificateGenerator;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;

public class ECEncodingTest
extends SimpleTest {
    private int m = 304;
    private int k1 = 1;
    private int k2 = 2;
    private int k3 = 11;
    private byte[] hexa;
    private byte[] hexb;
    private BigInteger a;
    private BigInteger b;
    private byte[] enc;

    public ECEncodingTest() {
        byte[] byArray = new byte[38];
        byArray[0] = -3;
        byArray[1] = 13;
        byArray[2] = 105;
        byArray[3] = 49;
        byArray[4] = 73;
        byArray[5] = -95;
        byArray[6] = 24;
        byArray[7] = -10;
        byArray[8] = 81;
        byArray[9] = -26;
        byArray[10] = -36;
        byArray[11] = -26;
        byArray[12] = -128;
        byArray[13] = 32;
        byArray[14] = -123;
        byArray[15] = 55;
        byArray[16] = 126;
        byArray[17] = 95;
        byArray[18] = -120;
        byArray[19] = 45;
        byArray[20] = 27;
        byArray[21] = 81;
        byArray[22] = 11;
        byArray[23] = 68;
        byArray[24] = 22;
        byArray[26] = 116;
        byArray[27] = -63;
        byArray[28] = 40;
        byArray[29] = -128;
        byArray[30] = 120;
        byArray[31] = 54;
        byArray[32] = 90;
        byArray[33] = 3;
        byArray[34] = -106;
        byArray[35] = -56;
        byArray[36] = -26;
        byArray[37] = -127;
        this.hexa = byArray;
        this.hexb = new byte[]{-67, -37, -105, -27, 85, -91, 10, -112, -114, 67, -80, 28, 121, -114, -91, -38, -90, 120, -113, 30, -94, 121, 78, -4, -11, 113, 102, -72, -63, 64, 57, 96, 30, 85, -126, 115, 64, -66};
        this.a = new BigInteger(1, this.hexa);
        this.b = new BigInteger(1, this.hexb);
        this.enc = new byte[]{2, 25, 123, 7, -124, 94, -101, -30, -39, 106, -37, 15, 95, 60, 127, 44, -1, -67, 122, 62, -72, -74, -2, -61, 92, 127, -42, 127, 38, -35, -10, 40, 90, 100, 79, 116, 10, 38, 20};
    }

    public String getName() {
        return "ECEncodingTest";
    }

    private void testPointCompression() throws Exception {
        ECCurve.F2m curve = new ECCurve.F2m(this.m, this.k1, this.k2, this.k3, this.a, this.b);
        ((ECCurve)curve).decodePoint(this.enc);
        int[] ks = new int[]{this.k3, this.k2, this.k1};
    }

    public void performTest() throws Exception {
        byte[] ecParams = Hex.decode("3081C8020101302806072A8648CE3D0101021D00D7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF303C041C68A5E62CA9CE6C1C299803A6C1530B514E182AD8B0042A59CAD29F43041C2580F63CCFE44138870713B1A92369E33E2135D266DBB372386C400B0439040D9029AD2C7E5CF4340823B2A87DC68C9E4CE3174C1E6EFDEE12C07D58AA56F772C0726F24C6B89E4ECDAC24354B9E99CAA3F6D3761402CD021D00D7C134AA264366862A18302575D0FB98D116BC4B6DDEBCA3A5A7939F020101");
        this.testParams(ecParams, true);
        this.testParams(ecParams, false);
        ecParams = Hex.decode("3081C8020101302806072A8648CE3D0101021D00D7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF303C041C56E6C7E4F11A7B4B961A4DCB5BD282EB22E42E9BCBE3E7B361F18012041C4BE3E7B361F18012F2353D22975E02D8D05D2C6F3342DD8F57D4C76F0439048D127A0C27E0DE207ED3B7FB98F83C8BD5A2A57C827F4B97874DEB2C1BAEB0C006958CE61BB1FC81F5389E288CB3E86E2ED91FB47B08FCCA021D00D7C134AA264366862A18302575D11A5F7AABFBA3D897FF5CA727AF53020101");
        this.testParams(ecParams, true);
        this.testParams(ecParams, false);
        ecParams = Hex.decode("30820142020101303c06072a8648ce3d0101023100fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff3066043100fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000fffffffc043100b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef046104aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab73617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f023100ffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973020101");
        this.testParams(ecParams, true);
        this.testParams(ecParams, false);
        this.testPointCompression();
    }

    private void testParams(byte[] ecParameterEncoded, boolean compress) throws Exception {
        String keyStorePass = "myPass";
        ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(ecParameterEncoded));
        X9ECParameters params = new X9ECParameters((ASN1Sequence)in.readObject());
        KeyPair kp = null;
        boolean success = false;
        while (!success) {
            byte[] y;
            byte[] x;
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECDSA");
            kpg.initialize(new ECParameterSpec(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed()));
            kp = kpg.generateKeyPair();
            JCEECPublicKey pubKey = (JCEECPublicKey)kp.getPublic();
            if (!compress) {
                pubKey.setPointFormat("UNCOMPRESSED");
            }
            if ((x = pubKey.getQ().getX().toBigInteger().toByteArray()).length != (y = pubKey.getQ().getY().toBigInteger().toByteArray()).length) continue;
            success = true;
        }
        Certificate[] chain = new Certificate[]{this.generateSelfSignedSoftECCert(kp, compress)};
        KeyStore keyStore = KeyStore.getInstance("BKS");
        keyStore.load(null, keyStorePass.toCharArray());
        keyStore.setCertificateEntry("ECCert", chain[0]);
        JCEECPrivateKey privateECKey = (JCEECPrivateKey)kp.getPrivate();
        keyStore.setKeyEntry("ECPrivKey", privateECKey, keyStorePass.toCharArray(), chain);
        JCEECPublicKey pub = (JCEECPublicKey)kp.getPublic();
        String oldPrivateKey = new String(Hex.encode(privateECKey.getEncoded()));
        String oldPublicKey = new String(Hex.encode(pub.getEncoded()));
        JCEECPrivateKey newKey = (JCEECPrivateKey)keyStore.getKey("ECPrivKey", keyStorePass.toCharArray());
        JCEECPublicKey newPubKey = (JCEECPublicKey)keyStore.getCertificate("ECCert").getPublicKey();
        if (!compress) {
            newKey.setPointFormat("UNCOMPRESSED");
            newPubKey.setPointFormat("UNCOMPRESSED");
        }
        String newPrivateKey = new String(Hex.encode(newKey.getEncoded()));
        String newPublicKey = new String(Hex.encode(newPubKey.getEncoded()));
        if (!oldPrivateKey.equals(newPrivateKey)) {
            this.fail("failed private key comparison");
        }
        if (!oldPublicKey.equals(newPublicKey)) {
            this.fail("failed public key comparison");
        }
    }

    private X509Certificate generateSelfSignedSoftECCert(KeyPair kp, boolean compress) throws InvalidKeyException, SignatureException {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        JCEECPrivateKey privECKey = (JCEECPrivateKey)kp.getPrivate();
        JCEECPublicKey pubECKey = (JCEECPublicKey)kp.getPublic();
        if (!compress) {
            privECKey.setPointFormat("UNCOMPRESSED");
            pubECKey.setPointFormat("UNCOMPRESSED");
        }
        certGen.setSignatureAlgorithm("ECDSAwithSHA1");
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(new X509Principal("CN=Software emul (EC Cert)"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000000L));
        certGen.setSubjectDN(new X509Principal("CN=Software emul (EC Cert)"));
        certGen.setPublicKey(pubECKey);
        return certGen.generateX509Certificate(privECKey);
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        ECEncodingTest.runTest(new ECEncodingTest());
    }
}

