/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.encoders.Hex;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class GOST28147Test
extends SimpleTest {
    static String[] cipherTests = new String[]{"256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d6520666f7220616c6c20", "281630d0d5770030068c252d841e84149ccc1912052dbc02", "256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d65208a920c6ed1a804f5", "88e543dfc04dc4f764fa7b624741cec07de49b007bf36065"};

    public String getName() {
        return "GOST28147";
    }

    public void testECB(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "GOST28147");
        Cipher in = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
        out.init(1, key);
        in.init(2, key);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        int i = 0;
        while (i != input.length / 2) {
            cOut.write(input[i]);
            ++i;
        }
        cOut.write(input, input.length / 2, input.length - input.length / 2);
        cOut.close();
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("GOST28147 failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        DataInputStream dIn = new DataInputStream(cIn);
        bytes = new byte[input.length];
        int i2 = 0;
        while (i2 != input.length / 2) {
            bytes[i2] = (byte)dIn.read();
            ++i2;
        }
        dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        if (!this.areEqual(bytes, input)) {
            this.fail("GOST28147 failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    public void testCFB(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "GOST28147");
        Cipher in = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
        Cipher out = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        out.init(1, (Key)key, new IvParameterSpec(iv));
        in.init(2, (Key)key, new IvParameterSpec(iv));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        int i = 0;
        while (i != input.length / 2) {
            cOut.write(input[i]);
            ++i;
        }
        cOut.write(input, input.length / 2, input.length - input.length / 2);
        cOut.close();
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("GOST28147 failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        DataInputStream dIn = new DataInputStream(cIn);
        bytes = new byte[input.length];
        int i2 = 0;
        while (i2 != input.length / 2) {
            bytes[i2] = (byte)dIn.read();
            ++i2;
        }
        dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        if (!this.areEqual(bytes, input)) {
            this.fail("GOST28147 failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    private void oidTest() {
        String[] oids = new String[]{CryptoProObjectIdentifiers.gostR28147_cbc.getId()};
        String[] names = new String[]{"GOST28147/CBC/PKCS7Padding"};
        try {
            byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            IvParameterSpec ivSpec = new IvParameterSpec(new byte[8]);
            int i = 0;
            while (i != oids.length) {
                Cipher c1 = Cipher.getInstance(oids[i], "BC");
                Cipher c2 = Cipher.getInstance(names[i], "BC");
                KeyGenerator kg = KeyGenerator.getInstance(oids[i], "BC");
                SecretKey k = kg.generateKey();
                c1.init(1, (Key)k, ivSpec);
                c2.init(2, (Key)k, ivSpec);
                byte[] result = c2.doFinal(c1.doFinal(data));
                if (!this.areEqual(data, result)) {
                    this.fail("failed OID test");
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.fail("failed exception " + ex.toString(), ex);
        }
    }

    public void performTest() throws Exception {
        int i = 0;
        while (i != cipherTests.length) {
            this.testECB(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
            this.testCFB(Integer.parseInt(cipherTests[i + 4]), Hex.decode(cipherTests[i + 4 + 1]), Hex.decode(cipherTests[i + 4 + 2]), Hex.decode(cipherTests[i + 4 + 3]));
            this.oidTest();
            i += 8;
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        GOST28147Test.runTest(new GOST28147Test());
    }
}

