/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.MultiCertStoreParameters;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.provider.test.CertPathTest;
import com.sansec.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;

public class MultiCertStoreTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.basicTest();
    }

    private void basicTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        list.add(rootCrl);
        list.add(interCrl);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store1 = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        CertStore store2 = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        ArrayList<CertStore> storeList = new ArrayList<CertStore>();
        storeList.add(store1);
        storeList.add(store2);
        CertStore store = CertStore.getInstance("Multi", new MultiCertStoreParameters(storeList));
        X509CertSelector targetConstraints = new X509CertSelector();
        targetConstraints.setSubject(rootCert.getSubjectX500Principal().getName());
        Collection<? extends Certificate> certs = store.getCertificates(targetConstraints);
        if (certs.size() != 2 || !certs.contains(rootCert)) {
            this.fail("2 rootCerts not found by subjectDN");
        }
        if ((certs = (store = CertStore.getInstance("Multi", new MultiCertStoreParameters(storeList, false))).getCertificates(targetConstraints)).size() != 1 || !certs.contains(rootCert)) {
            this.fail("1 rootCert not found by subjectDN");
        }
    }

    public String getName() {
        return "MultiCertStore";
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        MultiCertStoreTest.runTest(new MultiCertStoreTest());
    }
}

