/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.x509.GeneralName;
import com.sansec.asn1.x509.GeneralSubtree;
import com.sansec.jce.provider.PKIXNameConstraintValidator;
import com.sansec.jce.provider.PKIXNameConstraintValidatorException;
import com.sansec.util.test.SimpleTest;

public class PKIXNameConstraintsTest
extends SimpleTest {
    private static final String testEmail = "test@abc.test.com";
    private static final String[] testEmailIsConstraint = new String[]{"test@abc.test.com", "abc.test.com", ".test.com"};
    private static final String[] testEmailIsNotConstraint = new String[]{".abc.test.com", "www.test.com", "test1@abc.test.com", "bc.test.com"};
    private static final String[] email1 = new String[]{"test@test.com", "test@test.com", "test@test.com", "test@abc.test.com", "test@test.com", "test@test.com", ".test.com", ".test.com", ".test.com", ".test.com", "test.com", "abc.test.com", "abc.test1.com", "test.com", "test.com", ".test.com"};
    private static final String[] email2 = new String[]{"test@test.abc.com", "test@test.com", ".test.com", ".test.com", "test.com", "test1.com", "test@test.com", ".test.com", ".test1.com", "test.com", "test.com", ".test.com", ".test.com", "test1.com", ".test.com", "abc.test.com"};
    private static final String[] emailintersect;
    private static final String[][] emailunion;
    private static final String[] dn1;
    private static final String[] dn2;
    private static final String[][] dnUnion;
    private static final String[] dnIntersection;
    private static final String testDN = "O=test org, OU=test org unit, CN=John Doe";
    private static final String[] testDNIsConstraint;
    private static final String[] testDNIsNotConstraint;
    private static final String testDNS = "abc.test.com";
    private static final String[] testDNSIsConstraint;
    private static final String[] testDNSIsNotConstraint;
    private static final String[] dns1;
    private static final String[] dns2;
    private static final String[] dnsintersect;
    private static final String[][] dnsunion;
    private static final String testURI = "http://karsten:password@abc.test.com:8080";
    private static final String[] testURIIsConstraint;
    private static final String[] testURIIsNotConstraint;
    private static final String[] uri1;
    private static final String[] uri2;
    private static final String[] uriintersect;
    private static final String[][] uriunion;
    private static final byte[] testIP;
    private static final byte[][] testIPIsConstraint;
    private static final byte[][] testIPIsNotConstraint;
    private static final byte[][] ip1;
    private static final byte[][] ip2;
    private static final byte[][] ipintersect;
    private static final byte[][][] ipunion;

    static {
        String[] stringArray = new String[16];
        stringArray[1] = "test@test.com";
        stringArray[3] = testEmail;
        stringArray[4] = "test@test.com";
        stringArray[7] = ".test.com";
        stringArray[10] = "test.com";
        stringArray[11] = testDNS;
        stringArray[15] = testDNS;
        emailintersect = stringArray;
        emailunion = new String[][]{{"test@test.com", "test@test.abc.com"}, {"test@test.com"}, {"test@test.com", ".test.com"}, {".test.com"}, {"test.com"}, {"test@test.com", "test1.com"}, {".test.com", "test@test.com"}, {".test.com"}, {".test.com", ".test1.com"}, {".test.com", "test.com"}, {"test.com"}, {".test.com"}, {".test.com", "abc.test1.com"}, {"test1.com", "test.com"}, {".test.com", "test.com"}, {".test.com"}};
        dn1 = new String[]{testDN};
        dn2 = new String[]{"O=test org, OU=test org unit"};
        dnUnion = new String[][]{{"O=test org, OU=test org unit"}};
        dnIntersection = new String[]{testDN};
        testDNIsConstraint = new String[]{"O=test org, OU=test org unit", testDN};
        testDNIsNotConstraint = new String[]{"O=test org, OU=test org unit, CN=John Doe2", "O=test org, OU=test org unit2", "OU=test org unit, O=test org, CN=John Doe", "O=test org, OU=test org unit, CN=John Doe, L=USA"};
        testDNSIsConstraint = new String[]{"test.com", testDNS, "test.com"};
        testDNSIsNotConstraint = new String[]{"wwww.test.com", "ww.test.com", "www.test.com"};
        dns1 = new String[]{"www.test.de", "www.test1.de", "www.test.de"};
        dns2 = new String[]{"test.de", "www.test.de", "www.test.de"};
        String[] stringArray2 = new String[3];
        stringArray2[0] = "www.test.de";
        dnsintersect = stringArray2;
        dnsunion = new String[][]{{"test.de"}, {"www.test1.de", "www.test.de"}, {"www.test.de"}};
        testURIIsConstraint = new String[]{testDNS, ".test.com"};
        testURIIsNotConstraint = new String[]{"xyz.test.com", ".abc.test.com"};
        uri1 = new String[]{"www.test.de", ".test.de", "test1.de", ".test.de"};
        uri2 = new String[]{"test.de", "www.test.de", "test1.de", ".test.de"};
        String[] stringArray3 = new String[4];
        stringArray3[1] = "www.test.de";
        stringArray3[2] = "test1.de";
        stringArray3[3] = ".test.de";
        uriintersect = stringArray3;
        uriunion = new String[][]{{"www.test.de", "test.de"}, {".test.de"}, {"test1.de"}, {".test.de"}};
        testIP = new byte[]{-64, -88, 1, 2};
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[8];
        byArray[0] = -64;
        byArray[1] = -88;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArrayArray[0] = byArray;
        byArrayArray[1] = new byte[]{-64, -88, 1, 1, -1, -1, -1, 4};
        testIPIsConstraint = byArrayArray;
        testIPIsNotConstraint = new byte[][]{{-64, -88, 3, 1, -1, -1, -1, 2}, {-64, -88, 1, 1, -1, -1, -1, 3}};
        byte[][] byArrayArray2 = new byte[3][];
        byArrayArray2[0] = new byte[]{-64, -88, 1, 1, -1, -1, -2, -1};
        byArrayArray2[1] = new byte[]{-64, -88, 1, 1, -1, -1, -1, -1};
        byte[] byArray2 = new byte[8];
        byArray2[0] = -64;
        byArray2[1] = -88;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArrayArray2[2] = byArray2;
        ip1 = byArrayArray2;
        byte[][] byArrayArray3 = new byte[3][];
        byte[] byArray3 = new byte[8];
        byArray3[0] = -64;
        byArray3[1] = -88;
        byArray3[3] = 1;
        byArray3[4] = -1;
        byArray3[5] = -1;
        byArray3[6] = -4;
        byArray3[7] = 3;
        byArrayArray3[0] = byArray3;
        byArrayArray3[1] = new byte[]{-64, -88, 1, 1, -1, -1, -1, -1};
        byte[] byArray4 = new byte[8];
        byArray4[0] = -64;
        byArray4[1] = -88;
        byArray4[3] = 1;
        byArray4[4] = -1;
        byArray4[5] = -1;
        byArray4[6] = -1;
        byArrayArray3[2] = byArray4;
        ip2 = byArrayArray3;
        byte[][] byArrayArray4 = new byte[3][];
        byte[] byArray5 = new byte[8];
        byArray5[0] = -64;
        byArray5[1] = -88;
        byArray5[3] = 1;
        byArray5[4] = -1;
        byArray5[5] = -1;
        byArray5[6] = -2;
        byArray5[7] = -1;
        byArrayArray4[0] = byArray5;
        byArrayArray4[1] = new byte[]{-64, -88, 1, 1, -1, -1, -1, -1};
        ipintersect = byArrayArray4;
        byte[][][] byArrayArray5 = new byte[3][][];
        byte[][] byArrayArray6 = new byte[2][];
        byArrayArray6[0] = new byte[]{-64, -88, 1, 1, -1, -1, -2, -1};
        byte[] byArray6 = new byte[8];
        byArray6[0] = -64;
        byArray6[1] = -88;
        byArray6[3] = 1;
        byArray6[4] = -1;
        byArray6[5] = -1;
        byArray6[6] = -4;
        byArray6[7] = 3;
        byArrayArray6[1] = byArray6;
        byArrayArray5[0] = byArrayArray6;
        byArrayArray5[1] = new byte[][]{{-64, -88, 1, 1, -1, -1, -1, -1}};
        byte[][] byArrayArray7 = new byte[2][];
        byte[] byArray7 = new byte[8];
        byArray7[0] = -64;
        byArray7[1] = -88;
        byArray7[2] = 1;
        byArray7[3] = 1;
        byArray7[4] = -1;
        byArray7[5] = -1;
        byArray7[6] = -1;
        byArrayArray7[0] = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[0] = -64;
        byArray8[1] = -88;
        byArray8[3] = 1;
        byArray8[4] = -1;
        byArray8[5] = -1;
        byArray8[6] = -1;
        byArrayArray7[1] = byArray8;
        byArrayArray5[2] = byArrayArray7;
        ipunion = byArrayArray5;
    }

    public String getName() {
        return "PKIXNameConstraintsTest";
    }

    public void performTest() throws Exception {
        this.testConstraints(1, testEmail, testEmailIsConstraint, testEmailIsNotConstraint, email1, email2, emailunion, emailintersect);
        this.testConstraints(2, testDNS, testDNSIsConstraint, testDNSIsNotConstraint, dns1, dns2, dnsunion, dnsintersect);
        this.testConstraints(4, testDN, testDNIsConstraint, testDNIsNotConstraint, dn1, dn2, dnUnion, dnIntersection);
        this.testConstraints(6, testURI, testURIIsConstraint, testURIIsNotConstraint, uri1, uri2, uriunion, uriintersect);
        this.testConstraints(7, testIP, testIPIsConstraint, testIPIsNotConstraint, ip1, ip2, ipunion, ipintersect);
    }

    private void testConstraints(int nameType, String testName, String[] testNameIsConstraint, String[] testNameIsNotConstraint, String[] testNames1, String[] testNames2, String[][] testUnion, String[] testInterSection) throws Exception {
        PKIXNameConstraintValidator constraintValidator;
        int i = 0;
        while (i < testNameIsConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNameIsConstraint[i]))));
            constraintValidator.checkPermitted(new GeneralName(nameType, testName));
            ++i;
        }
        i = 0;
        while (i < testNameIsNotConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNameIsNotConstraint[i]))));
            try {
                constraintValidator.checkPermitted(new GeneralName(nameType, testName));
                this.fail("not permitted name allowed: " + nameType);
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < testNameIsConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNameIsConstraint[i])));
            try {
                constraintValidator.checkExcluded(new GeneralName(nameType, testName));
                this.fail("excluded name missed: " + nameType);
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < testNameIsNotConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNameIsNotConstraint[i])));
            constraintValidator.checkExcluded(new GeneralName(nameType, testName));
            ++i;
        }
        i = 0;
        while (i < testNames1.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNames1[i])));
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNames2[i])));
            PKIXNameConstraintValidator constraints2 = new PKIXNameConstraintValidator();
            int j = 0;
            while (j < testUnion[i].length) {
                constraints2.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testUnion[i][j])));
                ++j;
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("union wrong: " + nameType);
            }
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNames1[i]))));
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNames2[i]))));
            constraints2 = new PKIXNameConstraintValidator();
            if (testInterSection[i] != null) {
                constraints2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testInterSection[i]))));
            } else {
                constraints2.intersectEmptyPermittedSubtree(nameType);
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("intersection wrong: " + nameType);
            }
            ++i;
        }
    }

    private void testConstraints(int nameType, byte[] testName, byte[][] testNameIsConstraint, byte[][] testNameIsNotConstraint, byte[][] testNames1, byte[][] testNames2, byte[][][] testUnion, byte[][] testInterSection) throws Exception {
        PKIXNameConstraintValidator constraintValidator;
        int i = 0;
        while (i < testNameIsConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsConstraint[i])))));
            constraintValidator.checkPermitted(new GeneralName(nameType, new DEROctetString(testName)));
            ++i;
        }
        i = 0;
        while (i < testNameIsNotConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsNotConstraint[i])))));
            try {
                constraintValidator.checkPermitted(new GeneralName(nameType, new DEROctetString(testName)));
                this.fail("not permitted name allowed: " + nameType);
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < testNameIsConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsConstraint[i]))));
            try {
                constraintValidator.checkExcluded(new GeneralName(nameType, new DEROctetString(testName)));
                this.fail("excluded name missed: " + nameType);
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < testNameIsNotConstraint.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsNotConstraint[i]))));
            constraintValidator.checkExcluded(new GeneralName(nameType, new DEROctetString(testName)));
            ++i;
        }
        i = 0;
        while (i < testNames1.length) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames1[i]))));
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames2[i]))));
            PKIXNameConstraintValidator constraints2 = new PKIXNameConstraintValidator();
            int j = 0;
            while (j < testUnion[i].length) {
                constraints2.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testUnion[i][j]))));
                ++j;
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("union wrong: " + nameType);
            }
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames1[i])))));
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames2[i])))));
            constraints2 = new PKIXNameConstraintValidator();
            if (testInterSection[i] != null) {
                constraints2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testInterSection[i])))));
            } else {
                constraints2.intersectEmptyPermittedSubtree(nameType);
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("intersection wrong: " + nameType);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        PKIXNameConstraintsTest.runTest(new PKIXNameConstraintsTest());
    }
}

