/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.test.SimpleTest;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SlotTwoTest
extends SimpleTest {
    byte[] plainData = "abcdefghijklmnopqrstuvwxyz".getBytes();

    public String getName() {
        return "SlotTwo";
    }

    public void performTest() throws Exception {
        Security.removeProvider("BC");
        Security.insertProviderAt(new SwxaProvider(), 2);
        KeyGenerator keyGen = KeyGenerator.getInstance("DESede", "BC");
        keyGen.init(new SecureRandom());
        SecretKey key = keyGen.generateKey();
        this.testDesEde(key, "ECB", "PKCS7Padding");
        this.testDesEde(key, "CBC", "PKCS7Padding");
        this.testDesEde(key, "CTR", "NoPadding");
        this.testDesEde(key, "CTR", "PKCS7Padding");
        this.testDesEde(key, "OFB", "PKCS7Padding");
        this.testDesEde(key, "CFB", "PKCS7Padding");
        Security.removeProvider("BC");
        Security.addProvider(new SwxaProvider());
    }

    private void testDesEde(Key key, String mode, String padding) throws Exception {
        Cipher encrypt = Cipher.getInstance("DESede/" + mode + "/" + padding, "BC");
        Cipher decrypt = Cipher.getInstance("DESede/" + mode + "/" + padding);
        if (!decrypt.getProvider().getName().equals("BC")) {
            this.fail("BC provider not returned for DESede/" + mode + "/" + padding + " got " + decrypt.getProvider().getName());
        }
        encrypt.init(1, key);
        byte[] encryptedBytes = encrypt.doFinal(this.plainData);
        byte[] ivBytes = encrypt.getIV();
        if (ivBytes != null) {
            IvParameterSpec ivp = new IvParameterSpec(ivBytes);
            decrypt.init(2, key, ivp);
        } else {
            decrypt.init(2, key);
        }
        byte[] plainBytes = decrypt.doFinal(encryptedBytes, 0, encryptedBytes.length);
        if (!this.areEqual(this.plainData, plainBytes)) {
            this.fail("decryption test failed.");
        }
    }

    public static void main(String[] args) {
        SlotTwoTest.runTest(new SlotTwoTest());
    }
}

