/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider.test;

import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.test.SimpleTestResult;
import com.sansec.util.test.Test;
import com.sansec.util.test.TestResult;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class WrapTest
implements Test {
    public TestResult perform() {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", "BC");
            KeyPairGenerator fact = KeyPairGenerator.getInstance("RSA", "BC");
            fact.initialize(512, new SecureRandom());
            KeyPair keyPair = fact.generateKeyPair();
            PrivateKey priKey = keyPair.getPrivate();
            PublicKey pubKey = keyPair.getPublic();
            KeyGenerator keyGen = KeyGenerator.getInstance("DES", "BC");
            SecretKey wrapKey = keyGen.generateKey();
            cipher.init(3, wrapKey);
            byte[] wrappedKey = cipher.wrap(priKey);
            cipher.init(4, wrapKey);
            Key key = cipher.unwrap(wrappedKey, "RSA", 2);
            if (!MessageDigest.isEqual(priKey.getEncoded(), key.getEncoded())) {
                return new SimpleTestResult(false, "Unwrapped key does not match");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + e.toString());
        }
    }

    public String getName() {
        return "WrapTest";
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        WrapTest test = new WrapTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

