/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.spec;

import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String name;

    private static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        if (curve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)curve).getQ()), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        ECCurve.F2m curveF2m = (ECCurve.F2m)curve;
        if (curveF2m.isTrinomial()) {
            int[] ks = new int[]{curveF2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        int[] ks = new int[]{curveF2m.getK3(), curveF2m.getK2(), curveF2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
    }

    private static java.security.spec.ECPoint convertPoint(ECPoint g) {
        return new java.security.spec.ECPoint(g.getX().toBigInteger(), g.getY().toBigInteger());
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g, BigInteger n) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g), n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, java.security.spec.ECPoint g, BigInteger n) {
        super(curve, g, n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g, BigInteger n, BigInteger h) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g), n, h.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, java.security.spec.ECPoint g, BigInteger n, BigInteger h) {
        super(curve, g, n, h.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g, BigInteger n, BigInteger h, byte[] seed) {
        super(ECNamedCurveSpec.convertCurve(curve, seed), ECNamedCurveSpec.convertPoint(g), n, h.intValue());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

