/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsse.provider;

import com.sansec.jsse.provider.TlsPrfGenerator;
import com.sansec.jsse.provider.interfaces.TlsMasterSecret;
import com.sansec.jsse.provider.spec.TlsMasterSecretParameterSpec;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private TlsMasterSecretParameterSpec spec;
    private int protocolVersion;

    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)params;
        if (!"RAW".equals(this.spec.getPremasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.protocolVersion < 768 || this.protocolVersion > 770) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 supported");
        }
    }

    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        int premasterMinor;
        int premasterMajor;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        SecretKey premasterKey = this.spec.getPremasterSecret();
        byte[] premaster = premasterKey.getEncoded();
        if (premasterKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            premasterMajor = premaster[0] & 0xFF;
            premasterMinor = premaster[1] & 0xFF;
        } else {
            premasterMajor = -1;
            premasterMinor = -1;
        }
        String algortim = "";
        try {
            byte[] master;
            byte[] clientRandom = this.spec.getClientRandom();
            byte[] serverRandom = this.spec.getServerRandom();
            if (premasterKey.getAlgorithm().equals("TlsSm2PremasterSecret")) {
                byte[] seed = TlsPrfGenerator.concat(clientRandom, serverRandom);
                master = TlsPrfGenerator.doGbPRF(premaster, TlsPrfGenerator.LABEL_MASTER_SECRET, seed, 48);
                algortim = "GBTlsMasterSecret";
            } else {
                algortim = "StdTlsMasterSecret";
                if (this.protocolVersion >= 769) {
                    byte[] seed = TlsPrfGenerator.concat(clientRandom, serverRandom);
                    master = TlsPrfGenerator.doPRF(premaster, TlsPrfGenerator.LABEL_MASTER_SECRET, seed, 48);
                } else {
                    master = new byte[48];
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    MessageDigest sha = MessageDigest.getInstance("SHA");
                    byte[] tmp = new byte[20];
                    int i = 0;
                    while (i < 3) {
                        sha.update(TlsPrfGenerator.SSL3_CONST[i]);
                        sha.update(premaster);
                        sha.update(clientRandom);
                        sha.update(serverRandom);
                        sha.digest(tmp, 0, 20);
                        md5.update(premaster);
                        md5.update(tmp);
                        md5.digest(master, i << 4, 16);
                        ++i;
                    }
                }
            }
            return new TlsMasterSecretKey(master, premasterMajor, premasterMinor, algortim);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    private static final class TlsMasterSecretKey
    implements TlsMasterSecret {
        private static final long serialVersionUID = 1L;
        private byte[] key;
        private final int majorVersion;
        private final int minorVersion;
        private String algorithm;

        TlsMasterSecretKey(byte[] key, int majorVersion, int minorVersion, String algorithm) {
            this.key = key;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.algorithm = algorithm;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }
    }
}

