/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsse.provider;

import com.sansec.jsse.provider.spec.TlsPrfParameterSpec;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final byte[] B0 = new byte[0];
    static final byte[] LABEL_MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    static final byte[] LABEL_KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    static final byte[] LABEL_CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private static final byte[] HMAC_ipad = TlsPrfGenerator.genPad((byte)54, 64);
    private static final byte[] HMAC_opad = TlsPrfGenerator.genPad((byte)92, 64);
    static final byte[][] SSL3_CONST = TlsPrfGenerator.genConst();
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private TlsPrfParameterSpec spec;

    static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        int n1 = b1.length;
        int n2 = b2.length;
        byte[] b = new byte[n1 + n2];
        System.arraycopy(b1, 0, b, 0, n1);
        System.arraycopy(b2, 0, b, n1, n2);
        return b;
    }

    private static byte[][] genConst() {
        int n = 10;
        byte[][] arr = new byte[n][];
        int i = 0;
        while (i < n) {
            byte[] b = new byte[i + 1];
            Arrays.fill(b, (byte)(65 + i));
            arr[i] = b;
            ++i;
        }
        return arr;
    }

    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)params;
        SecretKey key = this.spec.getSecret();
        if (key != null && !"RAW".equals(key.getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
    }

    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        SecretKey key = this.spec.getSecret();
        byte[] secret = key == null ? null : key.getEncoded();
        try {
            byte[] labelBytes = this.spec.getLabel().getBytes("UTF8");
            int n = this.spec.getOutputLength();
            byte[] prfBytes = null;
            prfBytes = "GBTlsMasterSecret".equals(this.spec.getSecret().getAlgorithm()) ? TlsPrfGenerator.doGbPRF(secret, labelBytes, this.spec.getSeed(), n) : TlsPrfGenerator.doPRF(secret, labelBytes, this.spec.getSeed(), n);
            return new SecretKeySpec(prfBytes, "TlsPrf");
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not generate PRF", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProviderException("Could not generate PRF", e);
        }
    }

    static final byte[] doPRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength) throws NoSuchAlgorithmException, DigestException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        MessageDigest sha = MessageDigest.getInstance("SHA1");
        return TlsPrfGenerator.doPRF(secret, labelBytes, seed, outputLength, md5, sha);
    }

    static final byte[] doGbPRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength) throws NoSuchAlgorithmException, DigestException {
        MessageDigest sm3 = MessageDigest.getInstance("SM3");
        MessageDigest sha = MessageDigest.getInstance("SHA1");
        return TlsPrfGenerator.doGbPRF(secret, labelBytes, seed, outputLength, sha, sm3);
    }

    static final byte[] doPRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, MessageDigest md5, MessageDigest sha) throws DigestException {
        if (secret == null) {
            secret = B0;
        }
        int off = secret.length >> 1;
        int seclen = off + (secret.length & 1);
        byte[] output = new byte[outputLength];
        TlsPrfGenerator.expand(md5, 16, secret, 0, seclen, labelBytes, seed, output);
        TlsPrfGenerator.expand(sha, 20, secret, off, seclen, labelBytes, seed, output);
        return output;
    }

    static final byte[] doGbPRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, MessageDigest sha, MessageDigest sm3) throws DigestException {
        byte[] output = new byte[outputLength];
        TlsPrfGenerator.expand(sm3, 32, secret, 0, secret.length, labelBytes, seed, output);
        return output;
    }

    private static final void expand(MessageDigest digest, int hmacSize, byte[] secret, int secOff, int secLen, byte[] label, byte[] seed, byte[] output) throws DigestException {
        byte[] pad1 = (byte[])HMAC_ipad.clone();
        byte[] pad2 = (byte[])HMAC_opad.clone();
        int i = 0;
        while (i < secLen) {
            int n = i;
            pad1[n] = (byte)(pad1[n] ^ secret[i + secOff]);
            int n2 = i;
            pad2[n2] = (byte)(pad2[n2] ^ secret[i + secOff]);
            ++i;
        }
        byte[] tmp = new byte[hmacSize];
        byte[] aBytes = null;
        int remaining = output.length;
        int ofs = 0;
        while (remaining > 0) {
            digest.update(pad1);
            if (aBytes == null) {
                digest.update(label);
                digest.update(seed);
            } else {
                digest.update(aBytes);
            }
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            if (aBytes == null) {
                aBytes = new byte[hmacSize];
            }
            digest.digest(aBytes, 0, hmacSize);
            digest.update(pad1);
            digest.update(aBytes);
            digest.update(label);
            digest.update(seed);
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            digest.digest(tmp, 0, hmacSize);
            int k = Math.min(hmacSize, remaining);
            int i2 = 0;
            while (i2 < k) {
                int n = ofs++;
                output[n] = (byte)(output[n] ^ tmp[i2]);
                ++i2;
            }
            remaining -= k;
        }
    }
}

