/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsse.provider;

import com.sansec.jsse.provider.spec.TlsRsaPremasterSecretParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TlsRsaPremasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsRsaPremasterSecretGenerator must be initialized using a TlsRsaPremasterSecretParameterSpec";
    private TlsRsaPremasterSecretParameterSpec spec;
    private SecureRandom random;

    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsRsaPremasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsRsaPremasterSecretParameterSpec)params;
        this.random = random;
    }

    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsRsaPremasterSecretGenerator must be initialized");
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] b = new byte[48];
        this.random.nextBytes(b);
        b[0] = (byte)this.spec.getMajorVersion();
        b[1] = (byte)this.spec.getMinorVersion();
        return new SecretKeySpec(b, "TlsRsaPremasterSecret");
    }
}

