/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsse.provider.spec;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class TlsPrfParameterSpec
implements AlgorithmParameterSpec {
    private final SecretKey secret;
    private final String label;
    private final byte[] seed;
    private final int outputLength;

    public TlsPrfParameterSpec(SecretKey secret, String label, byte[] seed, int outputLength) {
        if (label == null || seed == null) {
            throw new NullPointerException("label and seed must not be null");
        }
        if (outputLength <= 0) {
            throw new IllegalArgumentException("outputLength must be positive");
        }
        this.secret = secret;
        this.label = label;
        this.seed = (byte[])seed.clone();
        this.outputLength = outputLength;
    }

    public SecretKey getSecret() {
        return this.secret;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    public int getOutputLength() {
        return this.outputLength;
    }
}

