/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.math.ec;

import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import java.math.BigInteger;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a, ECPoint Q, BigInteger b) {
        ECCurve c = P.getCurve();
        if (!c.equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, a, Q, b);
    }

    public static ECPoint shamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        if (!P.getCurve().equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, k, Q, l);
    }

    private static ECPoint implShamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        ECPoint Z = P.add(Q);
        ECPoint R = P.getCurve().getInfinity();
        int i = m - 1;
        while (i >= 0) {
            R = R.twice();
            if (k.testBit(i)) {
                R = l.testBit(i) ? R.add(Z) : R.add(P);
            } else if (l.testBit(i)) {
                R = R.add(Q);
            }
            --i;
        }
        return R;
    }
}

