/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.ocsp;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.ocsp.CertID;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.jce.PrincipalUtil;
import com.sansec.jce.X509Principal;
import com.sansec.ocsp.OCSPException;
import com.sansec.ocsp.OCSPUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class CertificateID {
    public static final String HASH_SHA1 = "1.3.14.3.2.26";
    private final CertID id;

    public CertificateID(CertID id) {
        if (id == null) {
            throw new IllegalArgumentException("'id' cannot be null");
        }
        this.id = id;
    }

    public CertificateID(String hashAlgorithm, X509Certificate issuerCert, BigInteger number, String provider) throws OCSPException {
        AlgorithmIdentifier hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), DERNull.INSTANCE);
        this.id = CertificateID.createCertID(hashAlg, issuerCert, new DERInteger(number), provider);
    }

    public CertificateID(String hashAlgorithm, X509Certificate issuerCert, BigInteger number) throws OCSPException {
        this(hashAlgorithm, issuerCert, number, "BC");
    }

    public String getHashAlgOID() {
        return this.id.getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public boolean matchesIssuer(X509Certificate issuerCert, String provider) throws OCSPException {
        return CertificateID.createCertID(this.id.getHashAlgorithm(), issuerCert, this.id.getSerialNumber(), provider).equals(this.id);
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CertificateID)) {
            return false;
        }
        CertificateID obj = (CertificateID)o;
        return this.id.getDERObject().equals(obj.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }

    private static CertID createCertID(AlgorithmIdentifier hashAlg, X509Certificate issuerCert, DERInteger serialNumber, String provider) throws OCSPException {
        try {
            MessageDigest digest = OCSPUtil.createDigestInstance(hashAlg.getObjectId().getId(), provider);
            X509Principal issuerName = PrincipalUtil.getSubjectX509Principal(issuerCert);
            digest.update(issuerName.getEncoded());
            DEROctetString issuerNameHash = new DEROctetString(digest.digest());
            PublicKey issuerKey = issuerCert.getPublicKey();
            ASN1InputStream aIn = new ASN1InputStream(issuerKey.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString issuerKeyHash = new DEROctetString(digest.digest());
            return new CertID(hashAlg, issuerNameHash, issuerKeyHash, serialNumber);
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }
}

