/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.ocsp;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1OutputStream;
import com.sansec.asn1.ocsp.BasicOCSPResponse;
import com.sansec.asn1.ocsp.OCSPObjectIdentifiers;
import com.sansec.asn1.ocsp.OCSPResponse;
import com.sansec.asn1.ocsp.ResponseBytes;
import com.sansec.ocsp.BasicOCSPResp;
import com.sansec.ocsp.OCSPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    public OCSPResp(InputStream in) throws IOException {
        this(new ASN1InputStream(in));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("malformed response: " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new IOException("malformed response: " + e.getMessage());
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1InputStream aIn = new ASN1InputStream(rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(aIn.readObject()));
            }
            catch (Exception e) {
                throw new OCSPException("problem decoding object: " + e, e);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.resp);
        return bOut.toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r = (OCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

