/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.ocsp;

import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.ocsp.OCSPObjectIdentifiers;
import com.sansec.asn1.ocsp.OCSPResponse;
import com.sansec.asn1.ocsp.OCSPResponseStatus;
import com.sansec.asn1.ocsp.ResponseBytes;
import com.sansec.ocsp.BasicOCSPResp;
import com.sansec.ocsp.OCSPException;
import com.sansec.ocsp.OCSPResp;
import java.io.IOException;

public class OCSPRespGenerator {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp generate(int status, Object response) throws OCSPException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        if (response instanceof BasicOCSPResp) {
            DEROctetString octs;
            BasicOCSPResp r = (BasicOCSPResp)response;
            try {
                octs = new DEROctetString(r.getEncoded());
            }
            catch (IOException e) {
                throw new OCSPException("can't encode object.", e);
            }
            ResponseBytes rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, octs);
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), rb));
        }
        throw new OCSPException("unknown response object");
    }
}

