/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.openssl;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.cms.ContentInfo;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.sec.ECPrivateKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.RSAPublicKeyStructure;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.jce.ECNamedCurveTable;
import com.sansec.jce.PKCS10CertificationRequest;
import com.sansec.jce.spec.ECNamedCurveParameterSpec;
import com.sansec.openssl.PEMException;
import com.sansec.openssl.PEMUtilities;
import com.sansec.openssl.PasswordException;
import com.sansec.openssl.PasswordFinder;
import com.sansec.util.encoders.Base64;
import com.sansec.util.encoders.Hex;
import com.sansec.x509.X509AttributeCertificate;
import com.sansec.x509.X509V2AttributeCertificate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;

public class PEMReader
extends BufferedReader {
    private final PasswordFinder pFinder;
    private final String provider;

    public PEMReader(Reader reader) {
        this(reader, null, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder pFinder) {
        this(reader, pFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder pFinder, String provider) {
        super(reader);
        this.pFinder = pFinder;
        this.provider = provider;
    }

    public Object readObject() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                return this.readPublicKey("-----END PUBLIC KEY");
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                return this.readRSAPublicKey("-----END RSA PUBLIC KEY");
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END CERTIFICATE REQUEST");
            }
            if (line.indexOf("-----BEGIN NEW CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END NEW CERTIFICATE REQUEST");
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (line.indexOf("-----BEGIN PKCS7") != -1) {
                return this.readPKCS7("-----END PKCS7");
            }
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                return this.readCRL("-----END X509 CRL");
            }
            if (line.indexOf("-----BEGIN ATTRIBUTE CERTIFICATE") != -1) {
                return this.readAttributeCertificate("-----END ATTRIBUTE CERTIFICATE");
            }
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("RSA", "-----END RSA PRIVATE KEY");
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PEMException("problem creating RSA private key: " + e.toString(), e);
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("DSA", "-----END DSA PRIVATE KEY");
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PEMException("problem creating DSA private key: " + e.toString(), e);
                }
            }
            if (line.indexOf("-----BEGIN EC PARAMETERS-----") != -1) {
                return this.readECParameters("-----END EC PARAMETERS-----");
            }
            if (line.indexOf("-----BEGIN EC PRIVATE KEY-----") == -1) continue;
            try {
                return this.readKeyPair("ECDSA", "-----END EC PRIVATE KEY-----");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating ECDSA private key: " + e.toString(), e);
            }
        }
        return null;
    }

    private byte[] readBytes(String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(String.valueOf(endMarker) + " not found");
        }
        return Base64.decode(buf.toString());
    }

    private PublicKey readRSAPublicKey(String endMarker) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(this.readBytes(endMarker));
        DERObject asnObject = ais.readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        RSAPublicKeyStructure rsaPubStructure = new RSAPublicKeyStructure(sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA", this.provider);
            return keyFact.generatePublic(keySpec);
        }
        catch (NoSuchProviderException e) {
            throw new IOException("can't find provider " + this.provider);
        }
        catch (Exception e) {
            throw new PEMException("problem extracting key: " + e.toString(), e);
        }
    }

    private PublicKey readPublicKey(String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.readBytes(endMarker));
        String[] algorithms = new String[]{"DSA", "RSA"};
        int i = 0;
        while (i < algorithms.length) {
            try {
                KeyFactory keyFact = KeyFactory.getInstance(algorithms[i], this.provider);
                PublicKey pubKey = keyFact.generatePublic(keySpec);
                return pubKey;
            }
            catch (NoSuchAlgorithmException keyFact) {
            }
            catch (InvalidKeySpecException keyFact) {
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("can't find provider " + this.provider);
            }
            ++i;
        }
        return null;
    }

    private X509Certificate readCertificate(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new PEMException("problem parsing cert: " + e.toString(), e);
        }
    }

    private X509CRL readCRL(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new PEMException("problem parsing cert: " + e.toString(), e);
        }
    }

    private PKCS10CertificationRequest readCertificateRequest(String endMarker) throws IOException {
        try {
            return new PKCS10CertificationRequest(this.readBytes(endMarker));
        }
        catch (Exception e) {
            throw new PEMException("problem parsing certrequest: " + e.toString(), e);
        }
    }

    private X509AttributeCertificate readAttributeCertificate(String endMarker) throws IOException {
        return new X509V2AttributeCertificate(this.readBytes(endMarker));
    }

    private ContentInfo readPKCS7(String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) break;
            line = line.trim();
            buf.append(line.trim());
            Base64.decode(buf.substring(0, buf.length() / 4 * 4), bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new IOException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(String.valueOf(endMarker) + " not found");
        }
        try {
            ASN1InputStream aIn = new ASN1InputStream(bOut.toByteArray());
            return ContentInfo.getInstance(aIn.readObject());
        }
        catch (Exception e) {
            throw new PEMException("problem parsing PKCS7 object: " + e.toString(), e);
        }
    }

    private KeyPair readKeyPair(String type, String endMarker) throws Exception {
        KeySpec privSpec;
        KeySpec pubSpec;
        boolean isEncrypted = false;
        String line = null;
        String dekInfo = null;
        StringBuffer buf = new StringBuffer();
        while ((line = this.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        byte[] keyBytes = Base64.decode(buf.toString());
        if (isEncrypted) {
            if (this.pFinder == null) {
                throw new PasswordException("No password finder specified, but a password is required");
            }
            char[] password = this.pFinder.getPassword();
            if (password == null) {
                throw new PasswordException("Password is null, but a password is required");
            }
            StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
            String dekAlgName = tknz.nextToken();
            byte[] iv = Hex.decode(tknz.nextToken());
            keyBytes = PEMUtilities.crypt(false, this.provider, keyBytes, password, dekAlgName, iv);
        }
        ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray(keyBytes);
        if (type.equals("RSA")) {
            DERInteger mod = (DERInteger)seq.getObjectAt(1);
            DERInteger pubExp = (DERInteger)seq.getObjectAt(2);
            DERInteger privExp = (DERInteger)seq.getObjectAt(3);
            DERInteger p1 = (DERInteger)seq.getObjectAt(4);
            DERInteger p2 = (DERInteger)seq.getObjectAt(5);
            DERInteger exp1 = (DERInteger)seq.getObjectAt(6);
            DERInteger exp2 = (DERInteger)seq.getObjectAt(7);
            DERInteger crtCoef = (DERInteger)seq.getObjectAt(8);
            pubSpec = new RSAPublicKeySpec(mod.getValue(), pubExp.getValue());
            privSpec = new RSAPrivateCrtKeySpec(mod.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else if (type.equals("ECDSA")) {
            ECPrivateKeyStructure pKey = new ECPrivateKeyStructure(seq);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, pKey.getParameters());
            PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey.getDERObject());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
            privSpec = new PKCS8EncodedKeySpec(privInfo.getEncoded());
            pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
        } else {
            DERInteger p = (DERInteger)seq.getObjectAt(1);
            DERInteger q = (DERInteger)seq.getObjectAt(2);
            DERInteger g = (DERInteger)seq.getObjectAt(3);
            DERInteger y = (DERInteger)seq.getObjectAt(4);
            DERInteger x = (DERInteger)seq.getObjectAt(5);
            privSpec = new DSAPrivateKeySpec(x.getValue(), p.getValue(), q.getValue(), g.getValue());
            pubSpec = new DSAPublicKeySpec(y.getValue(), p.getValue(), q.getValue(), g.getValue());
        }
        KeyFactory fact = KeyFactory.getInstance(type, this.provider);
        return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
    }

    private ECNamedCurveParameterSpec readECParameters(String endMarker) throws IOException {
        DERObjectIdentifier oid = (DERObjectIdentifier)ASN1Object.fromByteArray(this.readBytes(endMarker));
        return ECNamedCurveTable.getParameterSpec(oid.getId());
    }
}

