/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.openssl.test;

import com.sansec.asn1.cms.CMSObjectIdentifiers;
import com.sansec.asn1.cms.ContentInfo;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.spec.ECNamedCurveParameterSpec;
import com.sansec.openssl.PEMReader;
import com.sansec.openssl.PEMWriter;
import com.sansec.openssl.PasswordFinder;
import com.sansec.util.test.SimpleTest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class ReaderTest
extends SimpleTest {
    public String getName() {
        return "PEMReaderTest";
    }

    private PEMReader openPEMResource(String fileName, PasswordFinder pGet) {
        InputStream res = this.getClass().getResourceAsStream(fileName);
        BufferedReader fRd = new BufferedReader(new InputStreamReader(res));
        return new PEMReader((Reader)fRd, pGet);
    }

    public void performTest() throws Exception {
        block9: {
            Object o;
            Password pGet = new Password("secret".toCharArray());
            PEMReader pemRd = this.openPEMResource("test.pem", pGet);
            while ((o = pemRd.readObject()) != null) {
                boolean cfr_ignored_0 = o instanceof KeyPair;
            }
            pemRd = this.openPEMResource("pkcs7.pem", null);
            ContentInfo d = (ContentInfo)pemRd.readObject();
            if (!d.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
                this.fail("failed envelopedData check");
            }
            pemRd = this.openPEMResource("eckey.pem", null);
            ECNamedCurveParameterSpec spec = (ECNamedCurveParameterSpec)pemRd.readObject();
            KeyPair pair = (KeyPair)pemRd.readObject();
            Signature sgr = Signature.getInstance("ECDSA", "BC");
            sgr.initSign(pair.getPrivate());
            byte[] message = new byte[]{97, 98, 99};
            sgr.update(message);
            byte[] sigBytes = sgr.sign();
            sgr.initVerify(pair.getPublic());
            sgr.update(message);
            if (!sgr.verify(sigBytes)) {
                this.fail("EC verification failed");
            }
            if (!pair.getPublic().getAlgorithm().equals("ECDSA")) {
                this.fail("wrong algorithm name on public got: " + pair.getPublic().getAlgorithm());
            }
            if (!pair.getPrivate().getAlgorithm().equals("ECDSA")) {
                this.fail("wrong algorithm name on private");
            }
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
            pair = kpGen.generateKeyPair();
            this.keyPairTest("RSA", pair);
            kpGen = KeyPairGenerator.getInstance("DSA", "BC");
            kpGen.initialize(512, new SecureRandom());
            pair = kpGen.generateKeyPair();
            this.keyPairTest("DSA", pair);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
            pWrt.writeObject(d);
            pWrt.close();
            pemRd = new PEMReader(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
            d = (ContentInfo)pemRd.readObject();
            if (!d.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
                this.fail("failed envelopedData recode check");
            }
            this.doOpenSslDsaTest("unencrypted");
            this.doOpenSslRsaTest("unencrypted");
            this.doOpenSslTests("aes128");
            this.doOpenSslTests("aes192");
            this.doOpenSslTests("aes256");
            this.doOpenSslTests("blowfish");
            this.doOpenSslTests("des1");
            this.doOpenSslTests("des2");
            this.doOpenSslTests("des3");
            this.doOpenSslTests("rc2_128");
            this.doOpenSslDsaTest("rc2_40_cbc");
            this.doOpenSslRsaTest("rc2_40_cbc");
            this.doOpenSslDsaTest("rc2_64_cbc");
            this.doOpenSslRsaTest("rc2_64_cbc");
            try {
                pGet = new Password("7fd98".toCharArray());
                pemRd = this.openPEMResource("test.pem", pGet);
                while ((o = pemRd.readObject()) != null) {
                }
            }
            catch (IOException e) {
                if (e.getCause().getMessage().equals("corrupted stream - out of bounds length found")) break block9;
                this.fail("bounds issue not detected");
            }
        }
    }

    private void keyPairTest(String name, KeyPair pair) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        pWrt.writeObject(pair.getPublic());
        pWrt.close();
        PEMReader pemRd = new PEMReader(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        PublicKey k = (PublicKey)pemRd.readObject();
        if (!k.equals(pair.getPublic())) {
            this.fail("Failed public key read: " + name);
        }
        bOut = new ByteArrayOutputStream();
        pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        pWrt.writeObject(pair.getPrivate());
        pWrt.close();
        pemRd = new PEMReader(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        KeyPair kPair = (KeyPair)pemRd.readObject();
        if (!kPair.getPrivate().equals(pair.getPrivate())) {
            this.fail("Failed private key read: " + name);
        }
        if (!kPair.getPublic().equals(pair.getPublic())) {
            this.fail("Failed private key public read: " + name);
        }
    }

    private void doOpenSslTests(String baseName) throws IOException {
        this.doOpenSslDsaModesTest(baseName);
        this.doOpenSslRsaModesTest(baseName);
    }

    private void doOpenSslDsaModesTest(String baseName) throws IOException {
        this.doOpenSslDsaTest(String.valueOf(baseName) + "_cbc");
        this.doOpenSslDsaTest(String.valueOf(baseName) + "_cfb");
        this.doOpenSslDsaTest(String.valueOf(baseName) + "_ecb");
        this.doOpenSslDsaTest(String.valueOf(baseName) + "_ofb");
    }

    private void doOpenSslRsaModesTest(String baseName) throws IOException {
        this.doOpenSslRsaTest(String.valueOf(baseName) + "_cbc");
        this.doOpenSslRsaTest(String.valueOf(baseName) + "_cfb");
        this.doOpenSslRsaTest(String.valueOf(baseName) + "_ecb");
        this.doOpenSslRsaTest(String.valueOf(baseName) + "_ofb");
    }

    private void doOpenSslDsaTest(String name) throws IOException {
        String fileName = "dsa/openssl_dsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, DSAPrivateKey.class);
    }

    private void doOpenSslRsaTest(String name) throws IOException {
        String fileName = "rsa/openssl_rsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, RSAPrivateKey.class);
    }

    private void doOpenSslTestFile(String fileName, Class expectedPrivKeyClass) throws IOException {
        KeyPair kp;
        PrivateKey privKey;
        PEMReader pr = this.openPEMResource("data/" + fileName, new Password("changeit".toCharArray()));
        Object o = pr.readObject();
        if (o == null || !(o instanceof KeyPair)) {
            this.fail("Didn't find OpenSSL key");
        }
        if (!expectedPrivKeyClass.isInstance(privKey = (kp = (KeyPair)o).getPrivate())) {
            this.fail("Returned key not of correct type");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new SwxaProvider());
        ReaderTest.runTest(new ReaderTest());
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] word) {
            this.password = word;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

