/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.util;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(boolean[] a, boolean[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean constantTimeAreEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int nonEqual = 0;
        int i = 0;
        while (i != a.length) {
            nonEqual |= a[i] ^ b[i];
            ++i;
        }
        return nonEqual == 0;
    }

    public static boolean areEqual(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void fill(byte[] array, byte value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(long[] array, long value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(short[] array, short value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static int hashCode(byte[] data) {
        if (data == null) {
            return 0;
        }
        int i = data.length;
        int hc = i + 1;
        while (--i >= 0) {
            hc *= 257;
            hc ^= data[i];
        }
        return hc;
    }

    public static byte[] clone(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static int[] clone(int[] data) {
        if (data == null) {
            return null;
        }
        int[] copy = new int[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static void bytesFill(byte[] bytes, int filledNum, int len) {
        int i = 0;
        while (i < len) {
            bytes[i] = (byte)filledNum;
            ++i;
        }
    }
}

