/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.util;

import java.io.ByteArrayOutputStream;

public class ByteUtil {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String delimiter = " ";

    public static byte[] StringToByte(String str) {
        byte[] bytes = new byte[str.length() * 2];
        byte[] tmp = null;
        int i = 0;
        while (i < str.length()) {
            tmp = ByteUtil.CharToByte(str.charAt(i));
            bytes[i * 2] = tmp[0];
            bytes[i * 2 + 1] = tmp[1];
            ++i;
        }
        return bytes;
    }

    public static String ByteToString(byte[] bytes) {
        String str = "";
        byte[] tmp = new byte[2];
        int i = 0;
        while (i < str.length()) {
            tmp[0] = bytes[i * 2];
            tmp[1] = bytes[i * 2 + 1];
            str = String.valueOf(str) + ByteUtil.ByteToChar(tmp);
            ++i;
        }
        return str;
    }

    public static byte[] CharToByte(char num) {
        byte[] bytes = new byte[2];
        int i = 0;
        while (i < 2) {
            bytes[i] = (byte)(0xFF & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static char ByteToChar(byte[] bytes) {
        char num = '\u0000';
        int i = 0;
        while (i < 2) {
            num = (char)((long)num + ((0xFFL & (long)bytes[i]) << i * 8));
            ++i;
        }
        return num;
    }

    public static byte[] ShortToByte(short num) {
        byte[] bytes = new byte[2];
        int i = 0;
        while (i < 2) {
            bytes[i] = (byte)(0xFF & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static short ByteToShort(byte[] bytes) {
        short num = 0;
        int i = 0;
        while (i < 2) {
            num = (short)((long)num + ((0xFFL & (long)bytes[i]) << i * 8));
            ++i;
        }
        return num;
    }

    public static byte[] IntToByte(int num) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = (byte)(0xFF & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static int ByteToInt(byte[] bytes) {
        int num = 0;
        int i = 0;
        while (i < 4) {
            num = (int)((long)num + ((0xFFL & (long)bytes[i]) << i * 8));
            ++i;
        }
        return num;
    }

    public static byte[] LongToByte(long num) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static long ByteToLong(byte[] bytes) {
        long num = 0L;
        int i = 0;
        while (i < 8) {
            num += (0xFFL & (long)bytes[i]) << i * 8;
            ++i;
        }
        return num;
    }

    public static byte[] FloatToByte(float num) {
        int n = Float.floatToIntBits(num);
        return ByteUtil.IntToByte(n);
    }

    public static float ByteToFloat(byte[] b) {
        int n = ByteUtil.ByteToInt(b);
        return Float.intBitsToFloat(n);
    }

    public static byte[] DoubleToByte(double num) {
        long n = Double.doubleToLongBits(num);
        return ByteUtil.LongToByte(n);
    }

    public static double ByteToDouble(byte[] b) {
        long n = ByteUtil.ByteToLong(b);
        return Double.longBitsToDouble(n);
    }

    public static String bytes2hex(byte[] data) {
        return ByteUtil.bytes2hex(data, delimiter, data.length + 1);
    }

    public static byte[] hex2bytes(String str) {
        return ByteUtil.hex2bytes(str, "");
    }

    private static byte[] hex2bytes(String str, String delimiter) {
        str = str.toLowerCase();
        if ("".equals(delimiter)) {
            byte[] buf = new byte[str.length() / 2];
            int i = 0;
            while (i < buf.length) {
                char ch = str.charAt(i * 2);
                buf[i] = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
                ch = str.charAt(i * 2 + 1);
                if (ch >= 'a' && ch <= 'f') {
                    int n = i;
                    buf[n] = (byte)(buf[n] + (byte)(ch - 97 + 10));
                } else {
                    int n = i;
                    buf[n] = (byte)(buf[n] + (byte)(ch - 48));
                }
                ++i;
            }
            return buf;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String[] arr = str.split(delimiter);
        int i = 0;
        while (i < arr.length) {
            if (!arr[i].trim().equals("")) {
                baos.write(ByteUtil.hex2byte(arr[i]));
            }
            ++i;
        }
        return baos.toByteArray();
    }

    public static String byte2hex(byte n) {
        String str = "";
        str = String.valueOf(str) + HEX[(n & 0xF0) >> 4];
        str = String.valueOf(str) + HEX[n & 0xF];
        return str;
    }

    public static byte hex2byte(String str) {
        char ch = str.charAt(0);
        byte n = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
        ch = str.charAt(1);
        n = ch >= 'a' && ch <= 'f' ? (byte)(n + (byte)(ch - 97 + 10)) : (byte)(n + (byte)(ch - 48));
        return n;
    }

    private static String bytes2hex(byte[] data, String delimiter, int wrap) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            if (i != 0 && i % wrap == 0) {
                sb.append("\n");
            }
            sb.append(ByteUtil.byte2hex(data[i]));
            sb.append(delimiter);
            ++i;
        }
        sb.append(", " + data.length);
        return sb.toString();
    }
}

