/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.x509;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Set;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERSet;
import com.sansec.asn1.x509.Attribute;

public class X509Attribute
extends ASN1Encodable {
    Attribute attr;

    X509Attribute(ASN1Encodable at) {
        this.attr = Attribute.getInstance(at);
    }

    public X509Attribute(String oid, ASN1Encodable value) {
        this.attr = new Attribute(new DERObjectIdentifier(oid), new DERSet(value));
    }

    public X509Attribute(String oid, ASN1EncodableVector value) {
        this.attr = new Attribute(new DERObjectIdentifier(oid), new DERSet(value));
    }

    public String getOID() {
        return this.attr.getAttrType().getId();
    }

    public ASN1Encodable[] getValues() {
        ASN1Set s = this.attr.getAttrValues();
        ASN1Encodable[] values = new ASN1Encodable[s.size()];
        int i = 0;
        while (i != s.size()) {
            values[i] = (ASN1Encodable)s.getObjectAt(i);
            ++i;
        }
        return values;
    }

    public DERObject toASN1Object() {
        return this.attr.toASN1Object();
    }
}

